package com.elitesland.tw.tw5.server.prd.partner.team.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 业务伙伴-团队成员
 *
 * @author wangly
 * @date 2023-05-16
 */
@Entity
@Table(name = "com_business_team_member", indexes = {
        @Index(name = "index_object_id", columnList = "object_id"),
})
@org.hibernate.annotations.Table(appliesTo = "com_business_team_member", comment = "业务伙伴-团队成员")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessTeamMemberDO extends BaseModel implements Serializable {
    /**
     * 业务伙伴id business_partner.id
     */
    @Comment("业务id")
    @Column(name="object_id")
    private Long objectId;


    /**
     * 业务类型
     */
    @Comment("类型 udc[CRM:BUSINESS_PARTNER:TEAM_TYPE:PARTNER]")
    @Column()
    private String type;
    /**
     * 用户id
     */
    @Comment(" 用户id")
    @Column()
    private Long userId;
    /**
     * 成员名称
     */
    @Comment("成员名称")
    @Column()
    private String memberName;
    /**
     * 成员角色
     */
    @Comment("成员角色")
    @Column()
    private String memberRole;
    /**
     * 成员角色名称
     */
    @Comment("成员角色名称")
    @Column()
    private String memberRoleName;
    /**
     * 是否为创建者
     */
    @Comment("是否为创建者")
    @Column()
    private Boolean isCreator;
    /**
     * 组织id
     */
    @Comment("组织id")
    @Column()
    private Long orgId;
    /**
     * 维度id
     */
    @Comment("维度id")
    @Column()
    private Long dimensionId;
    /**
     * 组织改变前ID
     */
    @Comment("组织改变前ID")
    @Column()
    private Long changeId;
    /**
     * 组织名称
     */
    @Comment("组织名称")
    @Column()
    private String orgName;
    /**
     * 组织编号
     */
    @Comment("组织编号")
    @Column()
    private String orgCode;
    /**
     * 组织状态
     */
    @Comment("组织状态")
    @Column()
    private String orgStatus;
    /**
     * 排序号  创建人0，商务负责人5，服务负责人10， 采购负责人40，渠道负责人50，普通成员100
     */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /**
     * 扩展字段1
     */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /**
     * 扩展字段2
     */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /**
     * 扩展字段3
     */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /**
     * 扩展字段4
     */
    @Comment("扩展字段4")
    @Column()
    private String ext4;
    /**
     * 扩展字段5
     */
    @Comment("扩展字段5")
    @Column()
    private String ext5;


    /**
     * 业务伙伴id 以后如果需要将object_id换成book_id的值比较方便操作 预留字段
     */
    @Comment("业务id")
    @Column()
    private Long objectId_bak;

    public void copy(BusinessTeamMemberDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
