package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaConfigDataPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaConfigPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaConfigQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsMaConfigService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 项目经理任务书配置
 *
 * @author carl
 * @date 2023-09-19
 */
@Api(tags = "项目经理任务书配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/pmsMaConfig")
@Slf4j
public class PmsMaConfigController {

    private final PmsMaConfigService pmsMaConfigService;

    /**
     * 项目经理任务书配置-批量新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("项目经理任务书配置-批量新增或修改")
    public TwOutputUtil<PmsMaConfigVO> batchInsertOrUpdate(@RequestBody PmsMaConfigDataPayload payload) {
        pmsMaConfigService.batchInsertOrUpdate(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 项目经理任务书配置-新增或更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("项目经理任务书配置-新增或更新")
    public TwOutputUtil<PmsMaConfigVO> update(@RequestBody PmsMaConfigPayload payload) {
        return TwOutputUtil.ok(pmsMaConfigService.insertOrUpdate(payload));
    }

    /**
     * 项目经理任务书配置-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("项目经理任务书配置-主键查询")
    public TwOutputUtil<PmsMaConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsMaConfigService.queryByKey(key));
    }

    /**
     * 项目经理任务书配置-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("项目经理任务书配置-分页")
    public TwOutputUtil<PagingVO<PmsMaConfigVO>> paging(PmsMaConfigQuery query) {
        return TwOutputUtil.ok(pmsMaConfigService.queryPaging(query));
    }

    /**
     * 项目经理任务书配置-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("项目经理任务书配置-查询列表")
    public TwOutputUtil<List<PmsMaConfigVO>> queryList(PmsMaConfigQuery query) {
        return TwOutputUtil.ok(pmsMaConfigService.queryListDynamic(query));
    }

    /**
     * 项目经理任务书配置-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("项目经理任务书配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsMaConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

