package com.elitesland.tw.tw5.server.prd.pms.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributeRespondPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeRespondQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistBroadcastService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeCommonService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeRespondService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistBroadcastVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeRespondVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.DistributeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.RespondEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsDistributeConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeRespondDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistributeDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistributeRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 派发
 *
 * @author xxb
 * @date 2023-08-07
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsDistributeServiceImpl extends BaseServiceImpl implements PmsDistributeService {

    private final PmsDistributeRepo pmsDistributeRepo;
    private final PmsDistributeDAO pmsDistributeDAO;

    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final PmsDistBroadcastService distBroadcastService;

    private final WorkflowUtil workflowUtil;

    private final CacheUtil cacheUtil;

    private final PmsDistributeRespondDAO pmsDistributeRespondDAO;

    private final PmsDistributeRespondService distributeRespondService;

    private final TransactionUtilService transactionUtilService;

    private final PmsDistributeCommonService distributeCommonService;
    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsDistributeVO insertOrUpdate(PmsDistributePayload payload) {
        // 验空
        checkData(payload);
        // 检查单据时候是否已经派发过
        PmsDistributeVO distributeVO = pmsDistributeDAO.queryByReason(payload.getReasonId(), payload.getReasonType());
        if (!ObjectUtils.isEmpty(distributeVO)) {
            if (!distributeVO.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
                throw TwException.error("", "流程中派发不可再次发起");
            }
            payload.setId(distributeVO.getId());
            //赋值流程数据
            payload.setProcInstId(distributeVO.getProcInstId());
            payload.setApprStatus(distributeVO.getApprStatus());
        } else {
            payload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
            payload.setDistNo(generateSeqNum("PMS_DISTRIBUTE"));
        }

        // 保存派发表
        PmsDistributeDO entityDo = PmsDistributeConvert.INSTANCE.toDo(payload);
        entityDo = pmsDistributeRepo.save(entityDo);
//        Long disId = entityDo.getId();
//        Long disterResId = entityDo.getCreateUserId();
//
//
//        // 根据派发方式 做不同处理
//        if (DistributeEnum.distMethod.BROADCASTING.getCode().equals(payload.getDistMethod())) {
//            //新增广播表 要先判断 是否已经有了
//            PmsDistBroadcastQuery query = new PmsDistBroadcastQuery();
//            query.setDistId(disId);
//            List<PmsDistBroadcastVO> broadcastVOS = distBroadcastService.queryListDynamic(query);
//            if (ObjectUtils.isEmpty(broadcastVOS)) {
//                PmsDistBroadcastPayload broadcastPayload = payload.getBroadcastPayload();
//                broadcastPayload.setDistId(disId);
//                distBroadcastService.insert(broadcastPayload);
//            } else {
//                PmsDistBroadcastPayload broadcastPayload = payload.getBroadcastPayload();
//                distBroadcastService.update(broadcastPayload);
//            }
//
//            // 修改响应表
//            List<PmsDistributeRespondPayload> respondPayloads = payload.getRespondPayloads();
//            respondPayloads.forEach(v -> {
//                v.setDistId(disId);
//                v.setReasonName(payload.getReasonName());
//                v.setDisterResId(disterResId);
//            });
//            distributeRespondService.batchSave(respondPayloads, disId);
//
//            // 变更派发状态，由“新建”=>“广播中”
//            PmsDistributePayload payload0 = new PmsDistributePayload();
//            payload0.setId(disId);
//            payload0.setDistStatus(DistributeEnum.distStatus.BROADCASTING.getCode());
//            pmsDistributeDAO.updateWorkFlow(payload0);
//        } else {
//            //启动指定派发流程，并且变更派发状态，由“新建”=>“派发中”
//            distributeVO = PmsDistributeConvert.INSTANCE.toVo(entityDo);
//            // 判断 接收人是否是同一个人
//            Boolean samePeople = payload.getReceiverResId().equals(distributeVO.getReceiverResId());
//            distributeVO.setSamePeople(samePeople);
//            procStart(distributeVO);
//        }
        distributeVO = PmsDistributeConvert.INSTANCE.toVo(entityDo);
        return distributeVO;
    }


    @Override
    public PagingVO<PmsDistributeVO> queryPaging(PmsDistributeQuery query) {
        //处理权限
        operPermissionFlag(query);
        PagingVO<PmsDistributeVO> pagingVO = pmsDistributeDAO.queryPaging(query);
        if (pagingVO.getRecords().size() > 0) {
            //复合能力
            List<PmsDistributeVO> list = pagingVO.getRecords();
            if (!ObjectUtils.isEmpty(list)) {
                setCapasetLevelDesc(list);
                pagingVO.setRecords(list);
            }

            // 我的派发 才要显示 响应人数
            if (query.getMyDistFlag()) {
                List<Long> distIds = new ArrayList<>();
                pagingVO.getRecords().forEach(vo -> {
                    distIds.add(vo.getId());
                });
                PmsDistributeRespondQuery respondQuery = new PmsDistributeRespondQuery();
                respondQuery.setDistIds(distIds);
                List<PmsDistributeRespondVO> respondVOS = pmsDistributeRespondDAO.queryListDynamic(respondQuery);
                Map<Long, Long> groupCounts = respondVOS.stream()
                        .collect(Collectors.groupingBy(PmsDistributeRespondVO::getDistId, Collectors.counting()));
                pagingVO.getRecords().forEach(vo -> {
                    vo.setRepsePerson(groupCounts.get(vo.getId()));
                });
            }
        }
        return pagingVO;
    }

    /**
     * 权限处理
     *
     * @param query
     */
    void operPermissionFlag(PmsDistributeQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        //需要处理权限
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode()));
        query.setPermissionFlag(!rolePermission);
//        if (!rolePermission) {
//            Set<Long> longs = employeeService.querySubordinatesIdsByUserId(loginUserId);
//            query.setLowerUserIds(longs);
//
//        }
    }

    @Override
    public PagingVO<PmsDistributeVO> iReceivedRespond(PmsDistributeQuery query) {
        query.setDisterResId(GlobalUtil.getLoginUserId());
        query.setDistInnerJoinRespondFlag(true);
        query.setDistStatus(DistributeEnum.distStatus.BROADCASTING.getCode());
        return joinRespond(query);
    }

    @Override
    public PagingVO<PmsDistributeVO> iReceivedInvitation(PmsDistributeQuery query) {
        // 登录人=被邀请人
        query.setRespondentResId(GlobalUtil.getLoginUserId());
        query.setInviteFlag(1);
        query.setRespondInnerJoinDistFlag(true);
        query.setRespStatus(RespondEnum.NO_RESPONDING.getCode());
        PagingVO<PmsDistributeVO> pagingVO = joinRespond(query);
        if (!ObjectUtils.isEmpty(pagingVO)) {
            //复合能力
            List<PmsDistributeVO> list = pagingVO.getRecords();
            if (!ObjectUtils.isEmpty(list)) {
                setCapasetLevelDesc(list);
                pagingVO.setRecords(list);
            }
        }
        return pagingVO;
    }

    @Override
    public PagingVO<PmsDistributeVO> broadcastTaskKanban(PmsDistributeQuery query) {
        query.setRespondentResId(GlobalUtil.getLoginUserId());
        query.setBroadcastJoinDistFlag(true);
        query.setDistStatus(DistributeEnum.distStatus.BROADCASTING.getCode());
        // 登录人未响应过的派发数据（感兴趣和不感兴趣都算响应）
        List<PmsDistBroadcastVO> dos = distBroadcastService.findListByRespondentResId(query.getRespondentResId());
        List<Long> notInIds = dos.stream().map(v -> v.getId()).collect(Collectors.toList());
        query.setNotInIds(notInIds);
        PagingVO<PmsDistributeVO> pagingVO = joinRespond(query);
        if (!ObjectUtils.isEmpty(pagingVO)) {
            //复合能力
            List<PmsDistributeVO> list = pagingVO.getRecords();
            if (!ObjectUtils.isEmpty(list)) {
                setCapasetLevelDesc(list);
                pagingVO.setRecords(list);
            }
        }
        return pagingVO;
    }

    /**
     * 赋值 复合能力
     *
     * @param list
     */
    void setCapasetLevelDesc(List<PmsDistributeVO> list) {
        List<Long> distIds = new ArrayList<>();
        List<Long> capasetLevelIds = new ArrayList<>();
        list.forEach(vo -> {
            distIds.add(vo.getId());
            if (!ObjectUtils.isEmpty(vo.getCapasetLevelId())) {
                capasetLevelIds.add(vo.getCapasetLevelId());
            }
        });
        if (!ObjectUtils.isEmpty(capasetLevelIds)) {
            // 添加复合能力
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setIds(capasetLevelIds);
            List<PrdCompositeAbilityVO> levelVOS = prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
            Map<Long, PrdCompositeAbilityVO> info = levelVOS.stream().collect(Collectors.toMap(PrdCompositeAbilityVO::getId, Function.identity()));
            list.forEach(v -> {
                Long capasetLevelId = v.getCapasetLevelId();
                if (!ObjectUtils.isEmpty(capasetLevelId)) {
                    PrdCompositeAbilityVO levelVO = info.get(capasetLevelId);
                    if (!ObjectUtils.isEmpty(levelVO)) {
                        v.setEqvaRatio(levelVO.getDlRatio());
                        v.setCapasetLevelDesc(levelVO.getName());
                    }
                }
            });
        }
    }

    @Override
    public PagingVO<PmsDistributeVO> irespondedBroadcast(PmsDistributeQuery query) {
        query.setRespondentResId(GlobalUtil.getLoginUserId());
        query.setDistInnerJoinRespondFlag(true);
        query.setDistStatus(DistributeEnum.distStatus.BROADCASTING.getCode());
        return joinRespond(query);
    }

    /**
     * 关联响应表查询
     *
     * @param query
     * @return
     */
    private PagingVO<PmsDistributeVO> joinRespond(PmsDistributeQuery query) {
        List<PmsDistributeVO> list = pmsDistributeDAO.queryListDynamic(query);
        long total = list.size();
        List<PmsDistributeVO> result = list.stream().skip(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).collect(Collectors.toList());
        return PagingVO.<PmsDistributeVO>builder().records(result).total(total).build();
    }


    @Override
    public List<PmsDistributeVO> queryListDynamic(PmsDistributeQuery query) {
        return pmsDistributeDAO.queryListDynamic(query);
    }

    @Override
    public PmsDistributeVO queryByKey(Long key) {
        PmsDistributeDO entity = pmsDistributeRepo.findById(key).orElseGet(PmsDistributeDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsDistributeVO vo = PmsDistributeConvert.INSTANCE.toVo(entity);
        //添加复合能力
        /*if (!ObjectUtils.isEmpty(vo.getCapasetLevelId())) {
            PrdCompositeAbilityVO levelVO = prdCompositeAbilityService.get(vo.getCapasetLevelId());
            if (!ObjectUtils.isEmpty(levelVO)) {
                vo.setEqvaRatio(levelVO.getDlRatio());
                vo.setCapasetLevelDesc(levelVO.getName());
            }
        }*/

        PrdEmployeCompositeAbilityQuery compositeAbilityQuery = new PrdEmployeCompositeAbilityQuery();
        compositeAbilityQuery.setUserId(vo.getReceiverResId());
        List<PrdEmployeCompositeAbilityVO> compositeAbilityVOS = prdEmployeCompositeAbilityService.getList(compositeAbilityQuery);
        if (!ObjectUtils.isEmpty(compositeAbilityVOS)) {
            vo.setCompositeAbilityVOS(compositeAbilityVOS);
        }

        // 如果派发方式为广播  需要添加  派发响应列表
        if (DistributeEnum.distMethod.BROADCASTING.getCode().equals(vo.getDistMethod())) {
            PmsDistributeRespondQuery query = new PmsDistributeRespondQuery();
            query.setDistId(key);
            List<PmsDistributeRespondVO> respondList = distributeRespondService.queryListDynamic(query);
            vo.setRespondList(respondList);
        }

        return vo;
    }

    @Override
    public PmsDistributeVO queryByReason(Long reasonId, String reasonType) {
        return pmsDistributeDAO.queryByReason(reasonId, reasonType);
    }

    @Override
    public List<PmsDistributeVO> queryByReasons(List<Long> reasonIds, String reasonType) {
        return pmsDistributeDAO.queryByReasons(reasonIds, reasonType);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsDistributeVO> pmsDistributeVOS = pmsDistributeDAO.queryByKeys(keys);
            if (!ObjectUtils.isEmpty(pmsDistributeVOS)) {
                pmsDistributeVOS.forEach(vo -> {
                    if (!vo.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
                        throw TwException.error("", "仅支持新建状态的删除");
                    }
                    try {
                        //删除流程
                        if (StringUtils.hasText(vo.getProcInstId())) {
                            workflowUtil.deleteProcess(DeleteProcessPayload.of(vo.getProcInstId(), "收到删除派发数据"));
                        }
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
                distributeCommonService.deleteSoftByList(pmsDistributeVOS);
            }

        }
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsDistributePayload distributePayload = new PmsDistributePayload();
        distributePayload.setId(Long.parseLong(businessKey));
        distributePayload.setDistStatus(DistributeEnum.distStatus.DISTRIBUTING.getCode());
        //根据业务key查询当前业务对象

        PmsDistributeVO distributeVO = pmsDistributeDAO.queryByKey(Long.valueOf(businessKey));

        if (distributeVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
                    distributePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    distributePayload.setProcInstId(null);
                    distributePayload.setProcInstStatus(null);
                    distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
                    distributePayload.setDeleteFlag(1);
                    distributePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    distributeVO.setDeleteFlag(1);
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
                    distributePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    distributePayload.setDistStatus(DistributeEnum.distStatus.DISTRIBUTED.getCode());
                    distributePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    distributePayload.setApprovedTime(LocalDateTime.now());
                    break;
                case APPROVING:
                    break;
            }
            // 更新 派发 状态
            pmsDistributeDAO.updateWorkFlow(distributePayload);

            // 更新 派发事由 状态
            distributeVO.setDistStatus(distributePayload.getDistStatus());
            distributeCommonService.updateReasonStatus(distributeVO);
        }
    }

    @Override
    public void updateWorkFlow(PmsDistributePayload payload) {
        pmsDistributeDAO.updateWorkFlow(payload);
    }

//    @Override
//    public void setReceiverResId(long distId, long resId) {
//        // 设置接收资源
//        PmsDistributePayload payload = new PmsDistributePayload();
//        payload.setId(distId);
//        payload.setReceiverResId(resId);
//        pmsDistributeDAO.updateByKeyDynamic(payload);
//
//        //开启流程
//        procStart(pmsDistributeDAO.queryByKey(distId));
//    }


    /**
     * 启动派发流程
     *
     * @param distributeVO
     */
    private void procStart(PmsDistributeVO distributeVO) {
        ProcInstStatus procInstStatus = distributeVO.getProcInstStatus();
        String procInstId = distributeVO.getProcInstId();
        String distStatus = DistributeEnum.distStatus.DISTRIBUTING.getCode();
        String apprStatus = distributeVO.getApprStatus();
        //派发校验数据
        distributeCommonService.checkDistribute(distributeVO);
        if (procInstId == null) {
            //新建审批流
            HashMap<String, Object> batchMap = new HashMap<>();
            //接收人
            batchMap.put("Activity_1sfw1m6", Lists.newArrayList(distributeVO.getReceiverResId()));

            String disterResName = cacheUtil.getUserName(distributeVO.getDisterResId());
            String receiverResName = cacheUtil.getUserName(distributeVO.getReceiverResId());

            //流程实例名称 P01.任务包名称-派发（派发人-接包人）
            String procInstName = "P01" + "." + distributeVO.getReasonName() + "-派发(" + disterResName + "-" + receiverResName + ")";

            ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    PmsProcDefKey.PMS_DISTRIBUTE.name(),
                    procInstName,
                    distributeVO.getId() + "",
                    batchMap)

            );
            procInstId = processInfo.getProcInstId();
            procInstStatus = processInfo.getProcInstStatus();
            apprStatus = procInstStatus.name();
            if (procInstStatus.name().equals(ProcInstStatus.APPROVED.name())) {
                procInstId = null;
                distStatus = DistributeEnum.distStatus.DISTRIBUTED.getCode();
            }
        } else {
            if (!distributeVO.getSamePeople()) {
                //修改流程实例节点审批人
                HashMap<String, Object> batchMap = new HashMap<>();
                batchMap.put("Activity_1sfw1m6", Lists.newArrayList(distributeVO.getReceiverResId()));
                workflowUtil.setVariables(SetVariablesPayload.of(procInstId, batchMap));
            }
        }
        PmsDistributePayload payload0 = new PmsDistributePayload();
        payload0.setId(distributeVO.getId());
        payload0.setProcInstId(procInstId);
        payload0.setProcInstStatus(procInstStatus);
        payload0.setApprStatus(apprStatus);
        payload0.setDistStatus(distStatus);
        payload0.setNullFields(List.of("procInstId"));
        //开启事务执行修改，主要是修改审批状态
        distributeVO.setDistStatus(distStatus);
        transactionUtilService.executeWithRunnable(() -> {
            pmsDistributeDAO.updateWorkFlow(payload0);
            // 更新 派发事由 状态
            distributeCommonService.updateReasonStatus(distributeVO);
        });
    }

//    /**
//     * 更新 派发事由 状态
//     */
//    private void updateReasonStatus(PmsDistributeVO distributeVO) {
//        //更改项目状态   当接受资源通过派发后，会修改原项目的项目id
//        if (DistributeEnum.distType.PROJECT.getCode().equals(distributeVO.getReasonType())) {
//            // DISTRIBUTING 派发中  DISTRIBUTED 已派发
//            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTING.getCode())) {
//                pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.APPROVING.getCode(), distributeVO.getReceiverResId());
//            }
//            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTED.getCode())) {
//                pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.ACTIVE.getCode(), distributeVO.getReceiverResId());
//            }
//            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
//                pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.CREATE.getCode(), null);
//            }
//        }
//        //更改任务状态
//        if (DistributeEnum.distType.TASK.getCode().equals(distributeVO.getReasonType()) || DistributeEnum.distType.TASK_PACKAGE.getCode().equals(distributeVO.getReasonType())) {
//            String status = "";
//            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTING.getCode())) {
//                status = TaskStatusEnum.DISPATCH.getCode();
//            }
//            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTED.getCode())) {
//                status = TaskStatusEnum.INPROCESS.getCode();
//            }
//            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
//                status = TaskStatusEnum.CREATE.getCode();
//            }
//            distributeToTaskService.updateFromDistribute(distributeVO.getReasonType(), distributeVO.getReasonId(), distributeVO.getReceiverResId(), status);
//        }
//    }

    /**
     * 验证数据
     *
     * @param payload
     */
    private void checkData(PmsDistributePayload payload) {
        if (ObjectUtils.isEmpty(payload.getReasonType())) {
            throw TwException.error("", "派发类型 不可为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getReasonId())) {
            throw TwException.error("", "派发事由ID 不可为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getReasonName())) {
            throw TwException.error("", "派发事由 不可为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getDistMethod())) {
            throw TwException.error("", "派发方式 不可为空，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getDisterResId())) {
            throw TwException.error("", "派发资源ID 不可为空，请核验！");
        }

        if (ObjectUtils.isEmpty(payload.getDisterResName())) {
            throw TwException.error("", "派发资源名称 不可为空，请核验！");
        }
        // 指定派发时，接收资源 不可为空
        if (DistributeEnum.distMethod.DESIGNATE.getCode().equals(payload.getDistMethod())) {
            if (ObjectUtils.isEmpty(payload.getReceiverResId())) {
                throw TwException.error("", "接收资源ID 不可为空，请核验！");
            }
            if (ObjectUtils.isEmpty(payload.getReceiverResName())) {
                throw TwException.error("", "接收资源名称 不可为空，请核验！");
            }
        } else {
            if (ObjectUtils.isEmpty(payload.getWorkStyle())) {
                throw TwException.error("", "现场|远程 不可为空，请核验！");
            }
            if (ObjectUtils.isEmpty(payload.getTimeRequirement())) {
                throw TwException.error("", "时间要求 不可为空，请核验！");
            }
            if (ObjectUtils.isEmpty(payload.getMinSecurityLevel())) {
                throw TwException.error("", "最低信用级别 不可为空，请核验！");
            }

            List<PmsDistributeRespondPayload> respondPayloads = payload.getRespondPayloads();
            for (PmsDistributeRespondPayload respondPayload : respondPayloads) {
                if (ObjectUtils.isEmpty(respondPayload.getRespondentResId())) {
                    throw TwException.error("", "响应资源 不可为空，请核验！");
                }
            }
        }

    }

}
