package com.elitesland.tw.tw5.server.prd.product.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.product.payload.PrdProductCasePayload;
import com.elitesland.tw.tw5.api.prd.product.query.PrdProductCaseQuery;
import com.elitesland.tw.tw5.api.prd.product.service.PrdProductCaseService;
import com.elitesland.tw.tw5.api.prd.product.vo.PrdProductCaseVO;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.product.convert.PrdProductCaseConvert;
import com.elitesland.tw.tw5.server.prd.product.dao.PrdProductCaseDAO;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductCaseDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductCaseRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * 产品成功案例
 *
 * @author likunpeng
 * @date 2023-05-22
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdProductCaseServiceImpl extends BaseServiceImpl implements PrdProductCaseService {

    private final PrdProductCaseRepo prdProductCaseRepo;
    private final PrdProductCaseDAO prdProductCaseDAO;

    private final FileUtil fileUtil;

    @Override
    public PagingVO<PrdProductCaseVO> queryPaging(PrdProductCaseQuery query) {
        return prdProductCaseDAO.queryPaging(query);
    }

    @Override
    public List<PrdProductCaseVO> queryListDynamic(PrdProductCaseQuery query) {
        return prdProductCaseDAO.queryListDynamic(query);
    }

    @Override
    public PrdProductCaseVO queryByKey(Long key) {
        PrdProductCaseDO entity = prdProductCaseRepo.findById(key).orElseGet(PrdProductCaseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdProductCaseVO vo = PrdProductCaseConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    public List<PrdProductCaseVO> queryByProductKey(Long prodId) {
        PrdProductCaseQuery query = new PrdProductCaseQuery();
        query.setProdId(prodId);
        List<PrdProductCaseVO> prdProductCaseVOS = prdProductCaseDAO.queryListDynamic(query);
        setFileData(prdProductCaseVOS);
        return prdProductCaseVOS;
    }

    /**
     * 设置文件路径数据
     *
     * @param list
     */
    private void setFileData(List<PrdProductCaseVO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (PrdProductCaseVO vo : list) {
            vo.setCasePicData(fileUtil.getFileDatas(vo.getCasePicPath()));
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdProductCaseVO insert(PrdProductCasePayload payload) {
        PrdProductCaseDO entityDo = PrdProductCaseConvert.INSTANCE.toDo(payload);
        return PrdProductCaseConvert.INSTANCE.toVo(prdProductCaseRepo.save(entityDo));
    }

    @Override
    public List<PrdProductCaseVO> insertAll(List<PrdProductCasePayload> list) {
        List<PrdProductCaseDO> entityDoList = PrdProductCaseConvert.INSTANCE.toDo(list);
        return PrdProductCaseConvert.INSTANCE.toVo(prdProductCaseRepo.saveAll(entityDoList));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdProductCaseVO update(PrdProductCasePayload payload) {
        PrdProductCaseDO entity = prdProductCaseRepo.findById(payload.getId()).orElseGet(PrdProductCaseDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdProductCaseDO entityDo = PrdProductCaseConvert.INSTANCE.toDo(payload);
//        entity.copy(entityDo);
        return PrdProductCaseConvert.INSTANCE.toVo(prdProductCaseRepo.save(entityDo));
    }

    @Override
    public List<PrdProductCaseVO> updateAll(List<PrdProductCasePayload> payloads) {
        List<PrdProductCaseDO> prdProductCaseDOS = PrdProductCaseConvert.INSTANCE.toDo(payloads);
        return PrdProductCaseConvert.INSTANCE.toVo(prdProductCaseRepo.saveAll(prdProductCaseDOS));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdProductCaseDAO.deleteSoft(keys);
        }
    }

}
