package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 采购协议关联资源
 *
 * @author lemon
 * @date 2023-11-02
 */
@Entity
@Table(name = "purchase_agreement_res", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "purchase_agreement_res", comment = "采购协议关联资源")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseAgreementResDO extends BaseModel implements Serializable  {
    /** 资源ID */
    @Comment("资源ID")
    @Column()
    private Long resId;
    /** 采购协议单据ID */
    @Comment("采购协议单据ID")
    @Column()
    private Long documentId;
    /** 采购协议单据编号 */
    @Comment("采购协议单据编号")
    @Column()
    private String documentNo;
    /** 资源开始日期 */
    @Comment("资源开始日期")
    @Column()
    private LocalDate resStartDate;
    /** 资源结束日期 */
    @Comment("资源结束日期")
    @Column()
    private LocalDate resEndDate;

    public void copy(PurchaseAgreementResDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
