package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
 * 采购合同预估
 *
 * @author wangly
 * @date 2024-06-04
 */
@Entity
@Table(name = "purchase_estimated_revenue", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "purchase_estimated_revenue", comment = "采购合同预估")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchaseEstimatedRevenueDO extends BaseModel implements Serializable  {
    /** 采购合同ID */
    @Comment("采购合同ID")
    @Column()
    private Long purContractId;
    /** 销售合同ID */
    @Comment("销售合同ID")
    @Column()
    private Long saleContractId;
    /** 销售合同编号 */
    @Comment("销售合同编号")
    @Column()
    private String saleContractCode;
    /** 项目应付预估金额 */
    @Comment("项目应付预估金额")
    @Column()
    private BigDecimal expectPrice;
    /** 已核销应付预估金额 */
    @Comment("已核销应付预估金额")
    @Column()
    private BigDecimal writeoffExpectPrice;
    /** 剩余应付预估金额 */
    @Comment("剩余应付预估金额")
    @Column()
    private BigDecimal surplusExpectPrice;
    /** 应付预估时间 */
    @Comment("应付预估时间")
    @Column()
    private LocalDateTime expectTime;
    /** 应付预估科目 */
    @Comment("应付预估科目")
    @Column()
    private Long subjectId;
    /** 应付预估科目code */
    @Comment("应付预估科目code")
    @Column()
    private String subjectCode;
    /** 应付预估摘要 */
    @Comment("应付预估摘要")
    @Column()
    private String explanationName;
    /**
     * 预付款应付预估费用承担bu
     */
    @Comment("预付款应付预估费用承担bu")
    @Column()
    private Long expenseBuId;
    /** 预估凭证 */
    @Comment("预估凭证")
    @Column()
    private String expectVoucher;
    /** 预估应付类型 */
    @Comment("预估应付类型")
    @Column()
    private String purEstimatedRevenueType;
    /** 预估应付单据号 */
    @Comment("预估应付单据号")
    @Column()
    private String purEstimatedRevenueBatchNo;
    /** 预估应付公司 */
    @Comment("预估应付公司")
    @Column()
    private String purEstimatedRevenueCompany;
    /** 预估同步jde状态 */
    @Comment("预估同步jde状态")
    @Column()
    private String purExpectStatus;
    /** 预估失败原因 */
    @Comment("预估失败原因")
    @Column()
    private String purExpectFailReason;
    /** 预留字段1 */
    @Comment("预留字段1")
    @Column()
    private String ext1;
    /** 预留字段2 */
    @Comment("预留字段2")
    @Column()
    private String ext2;
    /** 预留字段3 */
    @Comment("预留字段3")
    @Column()
    private String ext3;
    /** 预留字段4 */
    @Comment("预留字段4")
    @Column()
    private String ext4;
    /** 预留字段5 */
    @Comment("预留字段5")
    @Column()
    private String ext5;

    public void copy(PurchaseEstimatedRevenueDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
