package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 付款申请单
 *
 * @author likunpeng
 * @date 2023-11-07
 */
@Entity
@Table(name = "t_purchase_payment", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "t_purchase_payment", comment = "付款申请单")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PurchasePaymentDO extends BaseModel implements Serializable  {
    /** 付款申请单编号 */
    @Comment("付款申请单编号")
    @Column()
    private String paymentNo;
    /** 付款申请单类型 */
    @Comment("付款申请单类型")
    @Column()
    @FieldUpdateLog(fieldName = "付款申请单类型" ,selectionKey = "purchase:payment_type")
    private String paymentApplicationType;
    /** 申请日期 */
    @Comment("申请日期")
    @Column()
    @FieldUpdateLog(fieldName = "申请日期")
    private LocalDate applicationDate;
    /** 供应商 */
    @Comment("供应商")
    @Column()
    private Long supplierLegalBookId;
    /** 验收方式 */
    @Comment("验收方式")
    @Column()
    @FieldUpdateLog(fieldName = "验收方式" ,selectionKey = "purchase:check")
    private String acceptanceType;
    /** 付款金额 */
    @Comment("付款金额")
    @Column()
    private BigDecimal paymentAmt;
    /** 本次付款金额 */
    @Comment("本次付款金额")
    @Column()
    private BigDecimal currPaymentAmt;
    /** 币种 */
    @Comment("币种")
    @Column()
    @FieldUpdateLog(fieldName = "币种" ,selectionKey = "SYSTEM_BASIC:CURRENCY")
    private String currCode;
    /** 付款申请人 */
    @Comment("付款申请人")
    @Column()
    @FieldUpdateLog(fieldName = "申请人" ,selectionKey = "USER")
    private Long purchaseInchargeResId;
    /** 付款申请单名称 */
    @Comment("付款申请单名称")
    @Column()
    @FieldUpdateLog(fieldName = "付款申请单名称")
    private String purchaseName;
    /** 发票核销状态 */
    @Comment("发票核销状态")
    @Column()
    private String invoiceState;
    /** 需求编号 */
    @Comment("需求编号")
    @Column()
    private String demandNo;
    /** 关联单据类型 */
    @Comment("关联单据类型")
    @Column()
    private String docType;
    /** 关联单据号 */
    @Comment("关联单据号")
    @Column()
    private String docNo;
    /** 关联销售合同 */
    @Comment("关联销售合同")
    @Column()
    private String relatedSalesContract;
    /** 关联项目号 */
    @Comment("关联项目号")
    @Column()
    private String relatedProjectNo;
    /** 付款依据 */
    @Comment("付款依据")
    @Column()
    private String basisFileCodes;
    /** 紧急付款凭证 */
    @Comment("紧急付款凭证")
    @Column()
    private String urgentPaymentCodes;
    /** 归属付款申请 */
    @Comment("归属付款申请")
    @Column()
    private String attributionPayApply;
    /** 发票编号 */
    @Comment("发票编号")
    @Column()
    private String invoiceNo;
    /** 发票金额 */
    @Comment("发票金额")
    @Column()
    private BigDecimal invoiceAmt;
    /** 税率 */
    @Comment("税率")
    @Column()
    private String rate;
    /** 税额 */
    @Comment("税额")
    @Column()
    private BigDecimal taxAmount;
    /** 付款方式 */
    @Comment("付款方式")
    @Column()
    @FieldUpdateLog(fieldName = "付款方式" ,selectionKey = "ACC:PAY_METHOD")
    private String payMethod;
    /** 预计付款日期 */
    @Comment("预计付款日期")
    @Column()
    @FieldUpdateLog(fieldName = "预计付款日期")
    private LocalDate payDate;
    /** 付款账期(天) */
    @Comment("付款账期(天)")
    @Column()
    private Integer relatedDays;
    /** 付款账期到期时间 */
    @Comment("付款账期到期时间")
    @Column()
    private LocalDateTime expRelatedDate;
    /** 收款人/单位BookId */
    @Comment("收款人/单位BookId")
    @Column()
    private Long receivingUnitBookId;
    /** 收款账号 */
    @Comment("收款账号")
    @Column()
    @FieldUpdateLog(fieldName = "收款账号")
    private String receivingId;
    /** 收款银行 */
    @Comment("收款银行")
    @Column()
    private String receivingBank;
    /** 预计核销日期 */
    @Comment("预计核销日期")
    @Column()
    private LocalDate expWriteOffDate;
    /** 付款公司地址簿Id */
    @Comment("付款公司地址簿Id")
    @Column()
    private Long payCompanyBookId;
    /** 付款银行 */
    @Comment("付款银行")
    @Column()
    private String paymentBank;
    /** 付款账号 */
    @Comment("付款账号")
    @Column()
    private String paymentId;
    /** 商机 */
    @Comment("商机")
    @Column()
    private String opportunity;
    /** 记账科目 */
    @Comment("记账科目")
    @Column()
    private Long accountingSubject;
    /** 财务记账付款公司 */
    @Comment("财务记账付款公司")
    @Column()
    private Long finalPaymentCompanyBookId;
    /** 财务记账付款银行 */
    @Comment("财务记账付款银行")
    @Column()
    private String finalPaymentBank;
    /** 财务记账付款账号 */
    @Comment("财务记账付款账号")
    @Column()
    private String finalPaymentId;
    /** 财务记账记账科目 */
    @Comment("财务记账记账科目")
    @Column()
    private Long finalAccountingSubject;
    /** 财务记账付款方式 */
    @Comment("财务记账付款方式")
    @Column()
    private String finalPayMethod;

    @ApiModelProperty("生成资产卡片(是/否) 0：否；1：是")
    @Column()
    private String assetFlag;

    @ApiModelProperty("现金流量码")
    @Column()
    private String flowCode;

    @ApiModelProperty("入账模块类型")
    @Column(columnDefinition = "varchar(100)")
    private String accountModuleType;

    /** 财务记账付款日期 */
    @Comment("财务记账付款日期")
    @Column()
    private LocalDate finalPayDate;
    /** 状态 */
    @Comment("状态")
    @Column()
    private String state;
    /** 流程场景 */
    @Comment("流程场景")
    @Column()
    private String scene;
    /** 是否无发票核销：0：否；1：是 */
    @Comment("是否无发票核销：0：否；1：是")
    @Column()
    private Integer noInvoiceVerification;
    /** 是否无单据核销：0：否；1：是 */
    @Comment("是否无单据核销：0：否；1：是")
    @Column()
    private Integer noDocVerification;
    /** 预付款申请单编号 */
    @Comment("预付款申请单编号")
    @Column()
    private String prePaymentNo;
    /** 财务记账付款核销日期 */
    @Comment("财务记账付款核销日期")
    @Column()
    private LocalDate finalWriteOffDate;
    /** 任务包 */
    @Comment("任务包")
    @Column()
    private Long relatedTask;
    /** 实际付款日期 */
    @Comment("实际付款日期")
    @Column()
    private LocalDate actualPayDate;
    /** 判断该付款申请单是否需要上传凭证: 0：否；1：是 */
    @Comment("判断该付款申请单是否需要上传凭证: 0：否；1：是")
    @Column()
    private Integer isNeedUpload;
    /** 支付标识：1.已支付 ；2.待支付 */
    @Comment("支付标识：1.已支付 ；2.待支付")
    @Column()
    private Integer payFlag;
    /** 申请单事由描述 */
    @Comment("申请单事由描述")
    @Column()
    @FieldUpdateLog(fieldName = "申请单事由描述")
    private String reasonDesc;
    /** 备注 */
    @Comment("备注")
    @Column()
    @FieldUpdateLog(fieldName = "备注")
    private String accountingNote;
    /** 财务记账备注 */
    @Comment("财务记账备注")
    @Column()
    @FieldUpdateLog(fieldName = "财务记账备注")
    private String finalAccountingNote;
    /** 流程实例ID */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /** 流程审批状态 */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    /** 审批时间 */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;
    /** 是否为驳回后再提交 */
    @Comment("是否为驳回后再提交")
    @Column()
    private Boolean isResubmit;
    /** 是否为紧急付款 */
    @Comment("是否为紧急付款")
    @Column()
    private Boolean urgentPaymentFlag;

    /**
     * 付款凭证
     */
    @Comment("JDE批次号")
    @Column(columnDefinition = "varchar(100)")
    private String jdeVoucher;

    /** jde单据公司 */
    @Comment("jde单据公司")
    @Column(columnDefinition = "varchar(100)")
    private String jdeCompany;
    /** jde单据号  */
    @Comment("jde单据号 ")
    @Column(columnDefinition = "varchar(100)")
    private String jdeDocumentNo;
    /** jde单据类型 */
    @Comment("jde单据类型")
    @Column(columnDefinition = "varchar(100)")
    private String jdeDocumentType;
    /** jde付款项 */
    @Comment("jde付款项")
    @Column(columnDefinition = "varchar(100)")
    private String jdePaymentItem;

    @Comment("jde付款号")
    @Column(columnDefinition = "varchar(100)")
    private String jdePayNo;

    @Comment("附件")
    @Column()
    private String fileCode;

    @Comment("是否子帐")
    @Column(columnDefinition = "varchar(50)")
    private String subAccountFlag;

    /** 费用承担bu 精确 */
    @Comment("费用承担bu")
    @Column(columnDefinition = "varchar(200)")
    private String expenseBuId;

    public void copy(PurchasePaymentDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
