package com.elitesland.tw.tw5.server.prd.salecon.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.OrgGrossProfitRateSettingPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.OrgGrossProfitRateSettingQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.OrgGrossProfitRateSettingService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.OrgGrossProfitRateSettingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 部门毛利率配置
 *
 * @folder 部门毛利率配置
 * @author wangly
 * @date 2024-04-01
 */
@Api(tags = "部门毛利率配置")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/orgGrossProfitRateSetting")
@Slf4j
public class OrgGrossProfitRateSettingController {

private final OrgGrossProfitRateSettingService orgGrossProfitRateSettingService;

    /**
     * 部门毛利率配置-新增
     *
     * @folder 部门毛利率配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("部门毛利率配置-新增")
    public TwOutputUtil<OrgGrossProfitRateSettingVO> insert(@RequestBody OrgGrossProfitRateSettingPayload payload){
         return TwOutputUtil.ok(orgGrossProfitRateSettingService.insert(payload));
    }

    /**
     * 部门毛利率配置-更新
     *
         * @folder 部门毛利率配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("部门毛利率配置-更新")
    public TwOutputUtil<OrgGrossProfitRateSettingVO> update(@RequestBody OrgGrossProfitRateSettingPayload payload){
        return TwOutputUtil.ok(orgGrossProfitRateSettingService.update(payload));
    }

    /**
     * 部门毛利率配置-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 部门毛利率配置
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("部门毛利率配置-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody OrgGrossProfitRateSettingPayload payload){
        return TwOutputUtil.ok(orgGrossProfitRateSettingService.updateByKeyDynamic(payload));
    }

    /**
     * 部门毛利率配置-主键查询
     *
     * @folder 部门毛利率配置
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("部门毛利率配置-主键查询")
    public TwOutputUtil<OrgGrossProfitRateSettingVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(orgGrossProfitRateSettingService.queryByKey(key));
    }

    /**
     * 部门毛利率配置-分页
     *
         * @folder 部门毛利率配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("部门毛利率配置-分页")
    public TwOutputUtil<PagingVO<OrgGrossProfitRateSettingVO>> paging(OrgGrossProfitRateSettingQuery query) {
        return TwOutputUtil.ok(orgGrossProfitRateSettingService.queryPaging(query));
    }

    /**
     * 部门毛利率配置-查询列表
     *
     * @folder 部门毛利率配置
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("部门毛利率配置-查询列表")
    public TwOutputUtil<List<OrgGrossProfitRateSettingVO>> queryList(OrgGrossProfitRateSettingQuery query) {
        return TwOutputUtil.ok(orgGrossProfitRateSettingService.queryListDynamic(query));
    }

    /**
     * 部门毛利率配置-删除
     *
         * @folder 部门毛利率配置
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("部门毛利率配置-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         orgGrossProfitRateSettingService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

