package com.elitesland.tw.tw5.server.prd.salecon.repo;

import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvBatchInvdtlDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * invdtl
 *
 * @author zoey
 * @date 2023-08-02
 */
public interface ConInvBatchInvdtlRepo extends JpaRepository<ConInvBatchInvdtlDO, Long>, JpaSpecificationExecutor<ConInvBatchInvdtlDO> {

    @Query("select count(id) from ConInvBatchInvdtlDO where invbatchId=?1 and deleteFlag=0")
    int findInvBatchInvDtlsCount(Long invId);

    @Query("select count(id) from ConInvBatchInvdtlDO where invNo=?1 and deleteFlag=0")
    int countInvByNo(String invNo);

    @Query(value = " select * from con_inv_batch_invdtl e where e.modify_time >= ?1", nativeQuery = true)
    List<ConInvBatchInvdtlDO> findByModifyTimeStart(String format);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update ConInvBatchInvdtlDO set invBatchInvdtlIdV4=?1,modifyTime=current_time  where id=?2")
    @Modifying
    void updateInvBatchInvdtlIdV4(Long idV4, Long id);

    @Transactional(rollbackFor = Exception.class)
    @Query(value = "update con_inv_batch_invdtl set modify_time=now()  where id=?1",nativeQuery = true)
    @Modifying
    void updateRemark(Long id);
}
