package com.elitesland.tw.tw5.server.prd.salecon.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConEpibolyCostConPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConEpibolyCostConQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConEpibolyCostConService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConDVO;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConEpibolyCostConVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwChannelCostConDEntity;
import com.elitesland.tw.tw5.server.common.crontask.payload.TwChannelCostConEntity;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConEpibolyCostConConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConEpibolyCostConDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConEpibolyCostConDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDDO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConEpibolyCostConDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConEpibolyCostConDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConEpibolyCostConRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.*;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 外包费用确认单
 *
 * @author likunpeng
 * @date 2023-04-17
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class ConEpibolyCostConServiceImpl extends BaseServiceImpl implements ConEpibolyCostConService {

    private final ConEpibolyCostConRepo conEpibolyCostConRepo;
    private final ConEpibolyCostConDAO conEpibolyCostConDAO;
    private final ConEpibolyCostConDDAO conEpibolyCostConDDAO;
    private final ConEpibolyCostConDRepo conEpibolyCostConDRepo;
    private final SaleConContractRepo saleConContractRepo;
    @Autowired
    private ConEpibolyCostConDService conEpibolyCostConDService;

    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;

//    @Value("${tw4.url}")
//    private String tw4_url;

    @Value("${tw4.sale.contractCost}")
    private String contractCost;


    @Override
    public PagingVO<ConEpibolyCostConVO> queryPaging(ConEpibolyCostConQuery query) {
        return conEpibolyCostConDAO.queryPaging(query);
    }

    @Override
    public List<ConEpibolyCostConVO> queryListDynamic(ConEpibolyCostConQuery query) {
        return conEpibolyCostConDAO.queryListDynamic(query);
    }

    @Override
    public ConEpibolyCostConVO queryByKey(Long key) {
        ConEpibolyCostConVO vo = conEpibolyCostConDAO.queryByKey(key);
        return vo;
    }

    @Override
    public ConEpibolyCostConVO queryOneByCostDId(Long key) {
        ConEpibolyCostConVO vo = new ConEpibolyCostConVO();
        ConEpibolyCostConDVO epibolyCostConDVO = conEpibolyCostConDService.queryByKey(key);
        if (ObjectUtils.isEmpty(epibolyCostConDVO)) {
            return vo;
        }
        // 查询拆分
        List<ConEpibolyCostConDVO> childrenList = conEpibolyCostConDService.queryByParentId(epibolyCostConDVO.getId());
        epibolyCostConDVO.setChildrenList(childrenList);
        epibolyCostConDVO.setSortNo("1");
        epibolyCostConDVO.setChildrenList(childrenList);
        int sortNo = 1;
        for (ConEpibolyCostConDVO children : childrenList) {
            children.setSortNo("1." + sortNo++);
        }
        // 查询主单据信息
        vo = queryByKey(epibolyCostConDVO.getEpibolyCostConId());
        if (ObjectUtils.isEmpty(vo)) {
            return vo;
        }
        vo.setConEpibolyCostConDVOS(Collections.singletonList(epibolyCostConDVO));
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConEpibolyCostConVO insert(ConEpibolyCostConPayload payload) {
        ConEpibolyCostConDO entityDo = ConEpibolyCostConConvert.INSTANCE.toDo(payload);
        String code = generateSeqNum("CON_QD");
        entityDo.setEpibolyCostNo(code);
        ConEpibolyCostConDO save = conEpibolyCostConRepo.save(entityDo);
        //新增主明细
        payload.setId(save.getId());
        insertOrUpdate(payload);
        return ConEpibolyCostConConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ConEpibolyCostConVO update(ConEpibolyCostConPayload payload) {
        ConEpibolyCostConDO entity = conEpibolyCostConRepo.findById(payload.getId()).orElseGet(ConEpibolyCostConDO::new);
        Assert.notNull(entity.getId(), "不存在");
        ConEpibolyCostConDO entityDo = ConEpibolyCostConConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        // 修改主明细
        insertOrUpdate(payload);
        return ConEpibolyCostConConvert.INSTANCE.toVo(conEpibolyCostConRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            conEpibolyCostConDAO.deleteSoft(keys);
        }
    }

    @Override
    public ConEpibolyCostConVO queryByContractId(Long contractId) {
        ConEpibolyCostConVO vo = conEpibolyCostConDAO.queryByContractId(contractId);
        if (vo == null) {
            return new ConEpibolyCostConVO();
        }
        //根据外包费用单ID查询对应的明细
        List<ConEpibolyCostConDVO> dvos = conEpibolyCostConDDAO.queryByepibolyCostConId(vo.getId());
        for (ConEpibolyCostConDVO dvo : dvos) {
            List<ConEpibolyCostConDVO> childrenList = conEpibolyCostConDService.queryByParentId(dvo.getId());
            dvo.setSortNo("1");
            dvo.setChildrenList(childrenList);
            int sortNo = 1;
            for (ConEpibolyCostConDVO children : childrenList) {
                children.setSortNo("1." + sortNo++);
            }
        }
        vo.setConEpibolyCostConDVOS(dvos);
        return vo;
    }

    @Override
    public void syncCostConTo4(String param) {
        String syncType = "cost_con_to4";
        LocalDateTime syncTime;
        if (StringUtils.hasText(param)) {
            syncTime = LocalDateTime.parse(param);
        } else {
            syncTime = daoLog.queryOrgSyncLog(syncType);
            if (syncTime == null) {
                syncTime = LocalDateTime.of(2023, 7, 1, 0, 0);
            } else {
                //将同步时间提前10秒，防止拉数据遗漏
                syncTime = syncTime.minusSeconds(120);
            }
        }
        XxlJobLogger.log("外包费用同步到4.0开始...");
        XxlJobLogger.log("syncCostConTo4 localDateTime：" + syncTime);

        // 查询待同步数据
        String format = DateUtil.format(syncTime, "yyyy-MM-dd HH:mm:ss");
        List<ConEpibolyCostConDO> querySyncDatas = conEpibolyCostConRepo.findByModifyTimeStart(format);

        // 同步内容
        String syncData = "";
        LocalDateTime syncNow = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(querySyncDatas)) {
            Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            Map<Long, Long> v4AndV5OrgIds = orgService.getV4AndV5OrgIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            // 组装同步的数据
            List<TwChannelCostConEntity> copy = new ArrayList<>();
            for (ConEpibolyCostConDO tempDo : querySyncDatas) {
//                List<Long> longs = conEpibolyCostConDRepo.ifSyncDetail(tempDo.getId());
//                if (ObjectUtils.isEmpty(longs)) {
//                    continue;
//                }
                // 查询需求明细表
                TwChannelCostConEntity e = new TwChannelCostConEntity();
                List<ConEpibolyCostConDDO> conEpibolyCostConDVOS = conEpibolyCostConDRepo.findCostConDDOByID(tempDo.getId());
                if (!ObjectUtils.isEmpty(conEpibolyCostConDVOS)) {
                    // 明细表
                    List<TwChannelCostConDEntity> detail = new ArrayList<>();
                    conEpibolyCostConDVOS.stream().forEach(item -> {
                        TwChannelCostConDEntity view = new TwChannelCostConDEntity();
                        view.setCostConDIdV5(item.getId());
                        view.setWorkType(item.getWorkType());
                        view.setReason(item.getReason());
                        view.setCoopType(item.getPartnerType());
                        view.setBase(item.getBase());
                        view.setChannelCostRem(item.getCollaborator());
                        if (item.getProportion() != null) {
                            view.setProportion(Long.valueOf(item.getProportion()));
                        }
                        view.setAmt(item.getAmt());
                        if (item.getTaxRate() != null) {
                            BigDecimal multiply = item.getTaxRate().multiply(new BigDecimal("100")).setScale(0, BigDecimal.ROUND_DOWN);
                            view.setTaxRate(Long.valueOf(multiply + ""));
                        }
                        view.setTaxCost(item.getTaxCost());
                        view.setReimExp(item.getTaxPayer());
                        view.setCostCondIdv4(item.getCostCondIdV4());
                        view.setNetPay(item.getNetPay());
                        view.setSalaryMethod(item.getPaymentMethod());
                        view.setContractStatus(item.getContractStatus());
                        view.setContactName(item.getLiaisonName());
                        view.setContactPhone(item.getLiaisonPhone());
                        view.setApplyStatus(item.getDetailedStatus());
                        view.setDelFlag(item.getDeleteFlag().equals(1) ? true : false);
                        // 4.0的申请状态是5.0的明细状态
                        if (item.getProcInstStatus() != null) {
                            if (ProcInstStatus.NOTSUBMIT.getDesc().equals(item.getProcInstStatus().getDesc())) {
                                view.setApprStatus("NOTSUBMIT");
                            } else if (ProcInstStatus.APPROVING.getDesc().equals(item.getProcInstStatus().getDesc())) {
                                view.setApprStatus("APPROVING");
                            } else if (ProcInstStatus.APPROVED.getDesc().equals(item.getProcInstStatus().getDesc())) {
                                view.setApprStatus("APPROVED");
                            } else if (ProcInstStatus.REJECTED.getDesc().equals(item.getProcInstStatus().getDesc())) {
                                view.setApprStatus("REJECTED");
                            }
                        }
                        // view.setDocType(item.getDocType());
                        // view.setDocumentNumber(item.getDocumentNumber());
                        // view.setChannelCostConDStatus(item.getDetailedStatus());
                        view.setMinChannelCostConId(item.getParentId());
                        if (StringUtils.hasText(item.getReceStage()) && item.getReceStage().matches("[0-9]+")) {
                            view.setReceivingNode(Long.valueOf(item.getReceStage()));
                        }
                        view.setDelFlag(item.getDeleteFlag() == 0 ? false : true);
                        detail.add(view);
                    });
                    e.setChannelCostConDEntities(detail);
                }
                e.setContractId(tempDo.getContractId());
                e.setChannelCostNo(tempDo.getEpibolyCostNo());
                e.setApplyResId(v4AndV5UserIds.get(tempDo.getApplyUserId()));
                e.setApplyBuId(v4AndV5OrgIds.get(tempDo.getApplyBuId()));
                if (tempDo.getApplyDate() != null) {
                    LocalDate date = tempDo.getApplyDate();
                    Instant instant = date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
                    e.setApplyDate(DateUtil.format(Date.from(instant), "yyyy-MM-dd HH:mm:ss"));
                }
                e.setChannelCostRem(tempDo.getRemark());
                e.setCostConIdV5(tempDo.getId());
                e.setCostConIdV4(tempDo.getCostConIdV4());
                e.setDelFlag(tempDo.getDeleteFlag() == 0 ? false : true);
                copy.add(e);
            }
            // 循环调用同步新增接口
            if (!ObjectUtils.isEmpty(copy)) {
                int failNum = 0;
                for (TwChannelCostConEntity temDo : copy) {
                    LocalDateTime syncStartTime = LocalDateTime.now();
                    try {
                        Map<String, Object> map = BeanUtil.beanToMap(temDo);
//                        String resultMain = httpUtil.sendPost(tw4_url + contractCost, map);
//                        Map<String, Object> data = (Map) JSON.parse(resultMain);
                    } catch (Exception e) {
                        XxlJobLogger.log("外包费用" + temDo.getCostConIdV5() + "同步异常......" + e);
                        LocalDateTime syncEndTime = LocalDateTime.now();
                        this.saveSyncLog(syncType + "_exception", "外包费用id" + temDo.getCostConIdV5() + "同步异常，" + syncStartTime + ":" + syncEndTime + ":" + (syncEndTime.toEpochSecond(ZoneOffset.of("+8")) - syncStartTime.toEpochSecond(ZoneOffset.of("+8"))) + "详情：" + e, null);
                        failNum++;
                        //更新该条合同的更新时间，下一次处理;
                        conEpibolyCostConRepo.updateRemark(temDo.getCostConIdV5());
                    }
                }
                syncData = "更新了" + (copy.size() - failNum) + "数据,有" + failNum + "条数据更新失败！";
            } else {
                syncData = "外包费用数据未变化";
            }
        } else {
            syncData = "外包费用数据未变化";
        }
        // 记录同步日志
        PrdOrgSyncLogDO logDO = this.saveSyncLog(syncType, syncData, syncNow);
        XxlJobLogger.log("同步外包费用结束..." + logDO);
    }

    @Override
    public void unbindReim(String reimNo) {
        conEpibolyCostConDDAO.unbindReim(reimNo);
    }

    private PrdOrgSyncLogDO saveSyncLog(String syncType, String syncData, LocalDateTime currentTime) {
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        logDO.setSyncTime(currentTime);
        daoLog.save(logDO);
        return logDO;
    }

    /**
     * 新增或者修改主明细判断
     *
     * @param payload
     */
    private List<ConEpibolyCostConDVO> insertOrUpdate(ConEpibolyCostConPayload payload) {
        List<ConEpibolyCostConDPayload> conEpibolyCostConDPayloadList = payload.getConEpibolyCostConDPayloads();
        //新增或者修改后的VO列表
        List<ConEpibolyCostConDVO> conEpibolyCostConDVOS = new ArrayList<>();
        Optional.ofNullable(conEpibolyCostConDPayloadList).ifPresent(list -> {
            for (ConEpibolyCostConDPayload conEpibolyCostConDPayload : list) {
                conEpibolyCostConDPayload.setEpibolyCostConId(payload.getId());
                if (ObjectUtils.isEmpty(conEpibolyCostConDPayload.getId()) || conEpibolyCostConDPayload.getId() < 0) {
                    ConEpibolyCostConDVO insert = conEpibolyCostConDService.insert(conEpibolyCostConDPayload);
                    conEpibolyCostConDVOS.add(insert);
                } else {
                    ConEpibolyCostConDVO update = conEpibolyCostConDService.update(conEpibolyCostConDPayload);
                    conEpibolyCostConDVOS.add(update);
                }
            }
        });

        return conEpibolyCostConDVOS;
    }
}
