package com.elitesland.tw.tw5.server.prd.schedule.controller;

import com.elitesland.tw.tw5.api.prd.schedule.payload.PrdSchedulePayload;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdScheduleQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdScheduleService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.PrdScheduleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 日程管理
 * @author zoey
 * @date 2022/4/19 - 14:17
 */
@Api("日程管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/scd")
@Slf4j
public class PrdScheduleController {

    private final PrdScheduleService service;

    /**
     * 新建或修改
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增")
    @PostMapping("/schedule/saveOne")
    public TwOutputUtil insert(@RequestBody PrdSchedulePayload payload) {
        PrdScheduleVO vo = service.insertOrUpdate(payload);
        return TwOutputUtil.ok(vo);
    }



    /**
     * 列表查询
     * @param query 查询参数
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/schedule/list")
    public TwOutputUtil queryList(PrdScheduleQuery query) {
        List<PrdScheduleVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }

//    /**
//     * 列表查询（根据日历id）
//     *
//     * @return result
//     */
//    @ApiOperation("列表查询")
//    @GetMapping("/schedule/list/{ids}")
//    public TwOutputUtil queryList(@PathVariable String ids) {
//        List<PrdScheduleVO> list = service.queryList(query);
//        return TwOutputUtil.ok(list);
//    }


    /**
     * 详情查询
     * @param id 主键
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/schedule/detail/{id}")
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        PrdScheduleVO vo= service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }



    /**
     * 逻辑删除
     * @param keys 主键
     * @return result
     */
    @DeleteMapping("/schedule/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

//    /**
//     * 删除重复日程的当天日程（exdate排除）
//     *
//     * @params: 日程id  触发日期
//     * @return result
//     */
//    @PostMapping("/schedule/deleteCurrent")
//    public TwOutputUtil deleteCurrent(@RequestBody Map<String,Object> params) {
//        service.deleteCurrent(params);
//        return TwOutputUtil.ok();
//    }
//
//    /**
//     * 删除重复日程的当天及以后日程（更改重复规则）
//     *
//     * @params: 日程id  触发日期
//     * @return result
//     */
//    @PostMapping("/schedule/deleteAfter")
//    public TwOutputUtil deleteAfter(@RequestBody Map<String,Object> params) {
//        service.deleteAfter(params);
//        return TwOutputUtil.ok();
//    }


    /**
     * 删除重复日程的当天日程（exdate排除）
     * @param scheduleId 日程id
     * @param date 触发日期
     * @return result
     */
    @GetMapping("/schedule/deleteCurrent")
    public TwOutputUtil deleteCurrent(@RequestParam Long scheduleId,@RequestParam String date) {
        service.deleteCurrent(scheduleId,date);
        return TwOutputUtil.ok();
    }

    /**
     * 删除重复日程的当天及以后日程（更改重复规则）
     * @param scheduleId 日程id
     * @param date 触发日期
     * @return result
     */
    @GetMapping("/schedule/deleteAfter")
    public TwOutputUtil deleteAfter(@RequestParam Long scheduleId,@RequestParam String date) {
        service.deleteAfter(scheduleId,date);
        return TwOutputUtil.ok();
    }



    /**
     * 更新重复日程的当天日程（exdate排除）
     * @param payload po类
     * @return result
     */
    @PostMapping("/schedule/updateCurrent")
    public TwOutputUtil updateCurrent(@RequestBody PrdSchedulePayload payload) {
        service.updateCurrent(payload);
        return TwOutputUtil.ok();
    }
    /**
     * 更新重复日程的当天及以后日程（更改重复规则）
     * @param payload po类
     * @return result
     */
    @PostMapping("/schedule/updateAfter")
    public TwOutputUtil updateAfter(@RequestBody PrdSchedulePayload payload) {
        service.updateAfter(payload);
        return TwOutputUtil.ok();
    }

}
