package com.elitesland.tw.tw5.server.prd.schedule.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name = "prd_activity_calendar")
@org.hibernate.annotations.Table(appliesTo = "prd_activity_calendar", comment = "活动日历表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdActivityCalendarDO extends BaseModel {

    @Comment("活动标题")
    @Column(nullable = false)
    private String title;

    @Comment("活动类型")
    @Column(nullable = false)
    private String type;

    @Comment("开始时间")
    @Column(nullable = false)
    private LocalDateTime startTime;

    @Comment("结束时间")
    @Column(nullable = false)
    private LocalDateTime endTime;

    @Comment("活动城市")
    @Column(nullable = false)
    private String city;

    @Comment("活动地点")
    @Column()
    private String location;

    @Comment("活动规模")
    @Column(nullable = false)
    private String scale;

    @Comment("活动负责人")
    @Column()
    private Long manageUserId;

    @Comment("参与人")
    @Column(columnDefinition = "text")
    private String participants;

    @Comment("直播地址")
    @Column()
    private String liveUrl;

    @Comment("日程id")
    @Column()
    private Long scheduleId;

    public void copy(PrdActivityCalendarDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
