package com.elitesland.tw.tw5.server.prd.shorturl.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 短链服务请求记录
 *
 * @author duwh
 * @date 2023-05-19
 */
@Entity
@Table(name = "prd_short_url_request_log", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_short_url_request_log", comment = "短链服务请求记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ShortUrlRequestLogDO extends BaseModel implements Serializable  {
    /** prd_short_url.id */
    @Comment("prd_short_url.id")
    @Column()
    private Long shortId;
    /** 短链地址 */
    @Comment("短链地址")
    @Column()
    private String shortUrl;
    /** 长链地址 */
    @Comment("长链地址")
    @Column()
    private String longUrl;
    /** 参数 */
    @Comment("参数")
    @Column()
    private String params;
    /** ip来源 */
    @Comment("ip来源")
    @Column()
    private String requestIp;
    /** 耗时 */
    @Comment("耗时")
    @Column()
    private Long time;
    /** 请求所属地址 */
    @Comment("请求所属地址")
    @Column()
    private String address;
    /** 浏览器 */
    @Comment("浏览器")
    @Column()
    private String browser;
    /** 拓展1 */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /** 拓展2 */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /** 拓展3 */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /** 拓展4 */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /** 拓展5 */
    @Comment("拓展5")
    @Column()
    private String ext5;

    public void copy(ShortUrlRequestLogDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
