package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionFieldQuery;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionRuleQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldObjRoleFunctionVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFieldVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleDetailVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionFieldType;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.entity.*;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemNewFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFieldObjRoleFunctionDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFunctionObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionRuleDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionRuleDetailDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionRuleDetailRepo;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemPermissionRuleRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @Author Bill
 * @Date 2023/9/25 15:48
 **/
@Repository
@RequiredArgsConstructor
public class PrdSystemPermissionRuleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemPermissionRuleRepo ruleRepo;
    private final QPrdSystemPermissionRuleDO qdoPermissionRule = QPrdSystemPermissionRuleDO.prdSystemPermissionRuleDO;
    private final PrdSystemPermissionRuleDetailRepo ruleDetailRepo;
    private final QPrdSystemPermissionRuleDetailDO qdoPermissionRuleDetail = QPrdSystemPermissionRuleDetailDO.prdSystemPermissionRuleDetailDO;
    private static final QPrdSystemBusinessObjectDO Q_BUSINESS_OBJECT_DO  = QPrdSystemBusinessObjectDO.prdSystemBusinessObjectDO;
    private final QPrdSystemPermissionFieldDO fieldDO = QPrdSystemPermissionFieldDO.prdSystemPermissionFieldDO;
    private final QPrdSystemPermissionFunctionObjectDO functionObjectDO = QPrdSystemPermissionFunctionObjectDO.prdSystemPermissionFunctionObjectDO;
    private final QPrdSystemPermissionFieldObjRoleFunctionDO qdoPermissionField = QPrdSystemPermissionFieldObjRoleFunctionDO.prdSystemPermissionFieldObjRoleFunctionDO;
    private final QPrdSystemRoleDO roleDO = QPrdSystemRoleDO.prdSystemRoleDO;
    private final QPrdSystemNewFunctionDO functionDO = QPrdSystemNewFunctionDO.prdSystemNewFunctionDO;
    private final QPrdOrgEmployeeRefDO qdoRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;
    private final QPrdOrgOrganizationDO qdoOrg = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdSystemNewFunctionDO qdoNewFunction = QPrdSystemNewFunctionDO.prdSystemNewFunctionDO;
    private final QPrdSystemPermissionFunctionObjectDO qdoFunctionObject = QPrdSystemPermissionFunctionObjectDO.prdSystemPermissionFunctionObjectDO;

    /**
     * 保存数据规则
     * @param entityDo
     */
    public PrdSystemPermissionRuleDO saveBusinessObjectDataRule(PrdSystemPermissionRuleDO entityDo) {
        return ruleRepo.save(entityDo);
    }

    /**
     * 根据数据权限编号查询
     * @param ruleCode
     * @return
     */
    public PrdSystemPermissionRuleDO queryPermissionRuleByCode(String ruleCode) {
        JPAQuery<PrdSystemPermissionRuleDO> jpaQuery = getJPAQueryPermissionRule();
        jpaQuery.where(qdoPermissionRule.ruleCode.eq(ruleCode));
        return jpaQuery.fetchOne();
    }

    /**
     * 拼装查询条件
     * @return
     */
    private JPAQuery<PrdSystemPermissionRuleDO> getJPAQueryPermissionRule() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionRuleDO.class,
                qdoPermissionRule.objectId,
                qdoPermissionRule.id,
                qdoPermissionRule.ruleCode,
                qdoPermissionRule.ruleScope,
                qdoPermissionRule.ruleType,
                qdoPermissionRule.deep,
                qdoPermissionRule.ruleScopeName)).from(qdoPermissionRule);
    }

    /**
     * 保存数据规则明细
     * @param ruleDetailDO
     */
    public PrdSystemPermissionRuleDetailDO saveBusinessObjectDataRuleDetail(PrdSystemPermissionRuleDetailDO ruleDetailDO) {
        return ruleDetailRepo.save(ruleDetailDO);
    }

    /**
     * 删除权限规则
     * @param keys
     */
    public void deletePermissonRuleByIds(Long[] keys) {
        ruleRepo.deleteAllById(Arrays.asList(keys));
    }

    /**
     * 查询权限规则明细
     * @param key
     * @return
     */
    public List<Long> queryPermissionRuleDetailIdsByRuleId(Long key) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoPermissionRuleDetail.id).from(qdoPermissionRuleDetail)
                .where(qdoPermissionRuleDetail.ruleId.longValue().eq(key));
        return jpaQuery.fetch();
    }

    /**
     * 删除权限规则明细
     * @param detailIds
     */
    public void deletePermissionRuleDetailByIds(List<Long> detailIds) {
        ruleDetailRepo.deleteAllById(detailIds);
    }

    /**
     * 查询权限规则
     * @param query
     * @return
     */
    public PagingVO<PrdSystemPermissionRuleVO> queryPermissionRule(PrdSystemPermissionRuleQuery query) {
        long total = count(query);
        if (total == 0){
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = getJPAQueryPermissionRuleWhere(query);
        List<PrdSystemPermissionRuleVO> result = jpaQuery.offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdSystemPermissionRuleVO>builder().records(result).total(total).build();
    }

    /**
     * 拼装查询条件
     * @return
     */
    private JPAQuery<PrdSystemPermissionRuleVO> getJPAQueryPermissionRules() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionRuleVO.class,
                qdoPermissionRule.objectId,
                qdoPermissionRule.id,
                qdoPermissionRule.ruleCode,
                qdoPermissionRule.ruleScope,
                qdoPermissionRule.ruleType,
                qdoPermissionRule.ruleScopeName,
                qdoPermissionRule.groupExpr,
                qdoPermissionRule.modifyTime,
                qdoPermissionRule.deep,
                qdoPermissionRule.modifyUserId,
                qdoPermissionRule.createTime,
                qdoPermissionRule.ruleTypeName,
                qdoPermissionRule.createUserId,
                qdoPermissionRule.ruleSubType,
                qdoPermissionRule.ruleSubTypeName,
                qdoPermissionRule.scopeType,
                qdoPermissionRule.scopeTypeName,
                qdoPermissionRule.levelScope,
                qdoPermissionRule.levelScopeName,
                qdoPermissionRule.functionId)).from(qdoPermissionRule);
    }

    /**
     * 拼装条件
     * @param query
     * @return
     */
    private JPAQuery<PrdSystemPermissionRuleVO> getJPAQueryPermissionRuleWhere(PrdSystemPermissionRuleQuery query) {
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = getJPAQueryPermissionRules();
        //条件封装
        jpaQuery.where(where(query));
        //基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdoPermissionRule._super, query);
        //动态擦汗寻
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoPermissionRule, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装条件
     * @param query
     * @return
     */
    private JPAQuery<PrdSystemPermissionRuleVO> getJPAQueryPermissionRuleByUserWhere(PrdSystemPermissionRuleQuery query) {
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = getJPAQueryPermissionRules();
        //条件封装
        jpaQuery.where(wherePermissionRuleByUser(query));
        //基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdoPermissionRule._super, query);
        //动态擦汗寻
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdoPermissionRule, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼接查询条件
     * @param query
     * @return
     */
    private Predicate where(PrdSystemPermissionRuleQuery query) {
        List<Predicate> list = new ArrayList<>();
        if (StringUtils.hasText(query.getRuleType())){
            list.add(qdoPermissionRule.ruleType.like(SqlUtil.toSqlLikeString(query.getRuleType())));
        }
        if (StringUtils.hasText(query.getRuleScopeName())){
            list.add(qdoPermissionRule.ruleScope.like(SqlUtil.toSqlLikeString(query.getRuleScopeName())));
        }
        list.add(qdoPermissionRule.functionId.longValue().eq(query.getFunctionId()));
        return ExpressionUtils.allOf(list);
    }

    /**
     * 拼接查询条件
     * @param query
     * @return
     */
    private Predicate wherePermissionRuleByUser(PrdSystemPermissionRuleQuery query) {
        List<Predicate> list = new ArrayList<>();
        if (!CollectionUtils.isEmpty(query.getOrgIds())) {
            list.add(qdoPermissionRule.ruleScope.eq(String.valueOf(query.getRoleId()))
                    .or(qdoPermissionRule.ruleScope.eq(String.valueOf(query.getUserId())))
                    .or(qdoPermissionRule.ruleScope.in(query.getOrgIds())));
        }else {
            list.add(qdoPermissionRule.ruleScope.eq(String.valueOf(query.getRoleId()))
                    .or(qdoPermissionRule.ruleScope.eq(String.valueOf(query.getUserId()))));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 统计数量
     * @param query
     * @return
     */
    private long count(PrdSystemPermissionRuleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoPermissionRule.count()).from(qdoPermissionRule);
        jpaQuery.where(where(query));
        //常用查询条件拼接
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdoPermissionRule._super, query);
        Long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 统计数量
     * @param query
     * @return
     */
    private long countPermissionRuleByUser(PrdSystemPermissionRuleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoPermissionRule.count()).from(qdoPermissionRule);
        jpaQuery.where(wherePermissionRuleByUser(query));
        //常用查询条件拼接
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdoPermissionRule._super, query);
        Long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 拼装权限规则详情信息
     * @return
     */
    public JPAQuery<PrdSystemPermissionRuleDetailDO> getJpaQueryPermissionRuleDetail() {
        JPAQuery<PrdSystemPermissionRuleDetailDO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdSystemPermissionRuleDetailDO.class,
                qdoPermissionRuleDetail.id,
                qdoPermissionRuleDetail.ruleId,
                qdoPermissionRuleDetail.ruleDetailCode,
                qdoPermissionRuleDetail.deep,
                qdoPermissionRuleDetail.ruleField,
                qdoPermissionRuleDetail.ruleValue,
                qdoPermissionRuleDetail.ruleConditionType)).from(qdoPermissionRuleDetail);
        return jpaQuery;
    }

    /**
     * 拼装权限规则详情信息
     * @return
     */
    public JPAQuery<PrdSystemPermissionRuleDetailVO> getJpaQueryPermissionRuleDetails() {
        JPAQuery<PrdSystemPermissionRuleDetailVO> jpaQuery = jpaQueryFactory.select(Projections.bean(PrdSystemPermissionRuleDetailVO.class,
                qdoPermissionRuleDetail.id,
                qdoPermissionRuleDetail.ruleId,
                qdoPermissionRuleDetail.ruleFieldName,
                qdoPermissionRuleDetail.ruleDetailCode,
                qdoPermissionRuleDetail.ruleField,
                qdoPermissionRuleDetail.ruleValue,
                qdoPermissionRuleDetail.ruleCondition,
                qdoPermissionRuleDetail.deep,
                qdoPermissionRuleDetail.ruleValueName,
                qdoPermissionRuleDetail.ruleConditionType,
                qdoPermissionRuleDetail.ruleSql,
                qdoPermissionRuleDetail.showType,
                qdoPermissionRuleDetail.showAttr
                )).from(qdoPermissionRuleDetail);
        return jpaQuery;
    }

    /**
     * 根据编号查询权限规则详情
     * @param ruleDetailCode
     * @return
     */
    public PrdSystemPermissionRuleDetailDO queryPermissionRuleDetailByCode(String ruleDetailCode) {
        JPAQuery<PrdSystemPermissionRuleDetailDO> jpaQuery = getJpaQueryPermissionRuleDetail();
        jpaQuery.where(qdoPermissionRuleDetail.ruleDetailCode.eq(ruleDetailCode));
        return jpaQuery.fetchOne();
    }

    /**
     * 根据编号查询权限规则详情
     * @param id
     * @return
     */
    public List<PrdSystemPermissionRuleDetailVO> queryPermissionRuleDetailByRuleId(Long id) {
        JPAQuery<PrdSystemPermissionRuleDetailVO> jpaQuery = getJpaQueryPermissionRuleDetails();
        jpaQuery.where(qdoPermissionRuleDetail.ruleId.longValue().eq(id));
        return jpaQuery.fetch();
    }

    public List<PrdSystemPermissionRuleVO> getAllByFunctionCode(String functionCode){
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = getJPAQueryPermissionRules();
        return jpaQuery.leftJoin(functionDO).on(qdoPermissionRule.functionId.eq(functionDO.id))
                .where(qdoPermissionRule.deleteFlag.eq(0))
                .where(functionDO.functionCode.eq(functionCode))
                .fetch();
    }

    /**
     * 根据用户查询数据权限
     *
     * @param query
     * @return
     */
    public PagingVO<PrdSystemPermissionRuleVO> queryPermissionRuleByUser(PrdSystemPermissionRuleQuery query) {
        long total = countPermissionRuleByUser(query);
        if (total == 0){
            return PagingVO.empty();
        }
        JPAQuery<PrdSystemPermissionRuleVO> jpaQuery = getJPAQueryPermissionRuleByUserWhere(query);
        List<PrdSystemPermissionRuleVO> result = jpaQuery.offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PrdSystemPermissionRuleVO>builder().records(result).total(total).build();
    }

    /**
     * 查询权限字段
     * @param query
     * @return
     */
    public List<PrdSystemPermissionFieldVO> queryPermissionFieldByFunctionId(PrdSystemPermissionFieldQuery query) {
        JPAQuery<PrdSystemPermissionFieldVO> jpaQuery = getJPAQueryPermissionField();
        if (StringUtils.hasText(query.getType())) {
            jpaQuery.where(qdoNewFunction.id.longValue().eq(query.getFunctionId()).and(fieldDO.fieldType.eq(query.getType())));
        }else {
            jpaQuery.where(qdoNewFunction.id.longValue().eq(query.getFunctionId()).and(fieldDO.fieldType.notIn(PermissionFieldType.BUSINESS_USER.getName(), PermissionFieldType.BUSINESS_DEPT.getName())));
        }
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询参数
     * @return
     */
    private JPAQuery<PrdSystemPermissionFieldVO> getJPAQueryPermissionField() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldVO.class,
                fieldDO.id,
                fieldDO.field,
                fieldDO.fieldName,
                fieldDO.fieldType
        )).from(qdoNewFunction).leftJoin(qdoFunctionObject).on(qdoFunctionObject.functionId.longValue().eq(qdoNewFunction.id.longValue()))
                .leftJoin(fieldDO).on(qdoFunctionObject.id.longValue().eq(fieldDO.functionObjectId.longValue()));
    }

    /**
     * 获取字段
     * @param objectCode
     * @param className
     * @return
     */
    public List<PrdSystemPermissionFieldObjRoleFunctionVO> getPermissionFieldRule(String objectCode, String className, String functionCode) {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFieldObjRoleFunctionVO.class,
                        Q_BUSINESS_OBJECT_DO.id.as("objectId"),
                        Q_BUSINESS_OBJECT_DO.objectCode,
                        Q_BUSINESS_OBJECT_DO.objectName,
                        fieldDO.field.as("fieldName"),
                        qdoPermissionField.isVisible,
                        qdoPermissionField.isEdit,
                        functionObjectDO.className,
                        functionObjectDO.functionId,
                        roleDO.roleCode
                )).from(qdoPermissionField)
                .leftJoin(fieldDO).on(qdoPermissionField.fieldId.eq(fieldDO.id))
                .leftJoin(functionObjectDO).on(fieldDO.functionObjectId.eq(functionObjectDO.id))
                .leftJoin(functionDO).on(functionDO.id.eq(functionObjectDO.functionId))
                .leftJoin(Q_BUSINESS_OBJECT_DO).on(functionObjectDO.objectId.eq(Q_BUSINESS_OBJECT_DO.id))
                .leftJoin(roleDO).on(qdoPermissionField.roleId.eq(roleDO.id))
                .where(Q_BUSINESS_OBJECT_DO.objectCode.eq(objectCode)
                        .and(functionObjectDO.className.eq(className))
                        .and(functionDO.functionCode.eq(functionCode)))
                .where(fieldDO.deleteFlag.eq(0)
                        .and(functionObjectDO.deleteFlag.eq(0))
                        .and(Q_BUSINESS_OBJECT_DO.deleteFlag.eq(0))
                        .and(roleDO.deleteFlag.eq(0))
                        .and(functionDO.deleteFlag.eq(0)))
                .fetch();
    }

    /**
     * 获取该用户的所有组织
     *
     * @param query
     * @return
     */
    public List<Long> getAllOrgByUserId(PrdSystemPermissionRuleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoOrg.id).from(qdoRef).leftJoin(qdoOrg).on(qdoOrg.id.longValue().eq(qdoRef.orgId.longValue()).and(qdoOrg.isCopy.eq(0)))
                .where((qdoRef.isCopy.eq(0)).and(qdoRef.deleteFlag.eq(0)).and(qdoRef.userId.longValue().eq(query.getUserId())));
        return jpaQuery.fetch();
    }
}
