package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Comment;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 数据权限规则
 *
 * @Author Bill
 * @Date 2023/9/25 13:22
 **/
@Entity
@Table(name = "prd_system_permission_rule")
@org.hibernate.annotations.Table(appliesTo = "prd_system_permission_rule", comment = "数据权限规则")
@Data
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdSystemPermissionRuleDO extends BaseModel {

    private static final long serialVersionUID = 2605502682085078492L;

    @Comment("业务对象主键")
    @Column(name = "object_id")
    private Long objectId;

    @Comment("规则编号")
    @Column(name = "rule_code")
    private String ruleCode;

    @Comment("规则类型")
    @Column(name = "rule_type")
    private String ruleType;

    @Comment("规则范围")
    @Column(name = "rule_scope")
    private String ruleScope;

    @Comment("规范范围名称")
    @Column(name = "rule_scope_name")
    private String ruleScopeName;

    @Comment("业务规则")
    @Column(name = "group_expr")
    private String groupExpr;

    @Comment("规则类型名称")
    @Column(name = "rule_type_name")
    private String ruleTypeName;

    @Comment("功能主键")
    @Column(name = "function_id")
    private Long functionId;

    @Comment("业务对象类型")
    @Column(name = "rule_sub_type")
    private String ruleSubType;

    @Comment("明细细节")
    @Column(name = "level_scope")
    private String levelScope;

    @Comment("业务对象类型名称")
    @Column(name = "rule_sub_type_name")
    private String ruleSubTypeName;

    @Comment("明细细节名称")
    @Column(name = "level_scope_name")
    private String levelScopeName;

    @Comment("范围类型")
    @Column(name = "scope_type")
    private String scopeType;

    @Comment("范围类型名称")
    @Column(name = "scope_type_name")
    private String scopeTypeName;

    @Column(name = "deep")
    @Comment("是否下钻")
    private Integer deep;

    public void copy(PrdSystemPermissionRuleDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
