package com.elitesland.tw.tw5.server.prd.system.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_shortcut")
@org.hibernate.annotations.Table(appliesTo = "prd_system_shortcut", comment = "系统快捷入口表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemShortcutDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("快捷入口名称")
    @Column()
    private String shortcutName;

    @Comment("快捷入口前端路由")
    @Column()
    private String portalRoute;

    @Comment("快捷入口图标")
    @Column()
    private String shortcutIcon;

    @Comment("快捷入口排序")
    @Column()
    private Integer sortIndex;

    @Comment("快捷入口状态 快捷入口状态 1是 0否")
    @Column()
    private Integer shortcutStatus = 1;

    @Comment("是否固定")
    @Column()
    private Boolean fixFlag;

    @Comment("类型")
    @Column()
    private String type;

    @Comment("web类型 app pc")
    @Column()
    private String webType;

    public void copy(PrdSystemShortcutDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
