package com.elitesland.tw.tw5.server.prd.system.service;

import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleFunctionService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleFunctionVO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleFunctionDAO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemRoleFunctionRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @Author Quruiqizz
 * @Date 2023/11/8 10:42
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdSystemRoleFunctionServiceImpl implements PrdSystemRoleFunctionService {

    private final PrdSystemRoleFunctionDAO dao;

    private final PrdSystemRoleFunctionRepo repo;

    /**
     * 根据功能编码和角色编码集合 查询关联关系
     *
     * @param functionCode
     * @param roleCodes
     * @return
     */
    @Override
    public Long listByFunctionCodeAndRoleCodes(String functionCode, List<String> roleCodes) {
        return dao.listByFunctionCodeAndRoleCodes(functionCode, roleCodes);
    }

}
