package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypePermissionPrevRecordVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 易稻壳yeedoc通用文档类型配置表
 *
 * @author duwh
 * @date 2023-12-07
 */
@Api(tags = "易稻壳yeedoc通用文档类型配置表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessDocTypeConfig")
@Slf4j
public class BusinessDocTypeConfigController {

    private final BusinessDocTypeConfigService businessDocTypeConfigService;

    /**
     * 易稻壳yeedoc通用文档类型配置表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("易稻壳yeedoc通用文档类型配置表-新增")
    public TwOutputUtil<BusinessDocTypeConfigVO> insert(@RequestBody BusinessDocTypeConfigPayload payload) {
        return TwOutputUtil.ok(businessDocTypeConfigService.insert(payload));
    }

    // /**
    //  * 易稻壳yeedoc通用文档类型配置表-更新
    //  *
    //  * @param payload 有效载荷
    //  * @return {@link TwOutputUtil}
    //  */
    // @PutMapping
    // @ApiOperation("易稻壳yeedoc通用文档类型配置表-更新")
    // public TwOutputUtil<BusinessDocTypeConfigVO> update(@RequestBody BusinessDocTypeConfigPayload payload){
    //     return TwOutputUtil.ok(businessDocTypeConfigService.update(payload));
    // }

    /**
     * 易稻壳yeedoc通用文档类型配置表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("易稻壳yeedoc通用文档类型配置表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessDocTypeConfigPayload payload) {
        return TwOutputUtil.ok(businessDocTypeConfigService.updateByKeyDynamic(payload));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置表-主键查询")
    public TwOutputUtil<BusinessDocTypeConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessDocTypeConfigService.queryByKey(key));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置表-分页")
    public TwOutputUtil<PagingVO<BusinessDocTypeConfigVO>> paging(BusinessDocTypeConfigQuery query) {
        return TwOutputUtil.ok(businessDocTypeConfigService.queryPaging(query));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("易稻壳yeedoc通用文档类型配置表-查询列表")
    public TwOutputUtil<List<BusinessDocTypeConfigVO>> queryList(BusinessDocTypeConfigQuery query) {
        return TwOutputUtil.ok(businessDocTypeConfigService.queryListDynamic(query));
    }

    /**
     * 易稻壳yeedoc通用文档类型配置表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("易稻壳yeedoc通用文档类型配置表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessDocTypeConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 获取yeeedoc信息
     *
     * @param docId            业务主键 示例：项目id、合同id
     * @param docType          单据类型 示例：PMS_PROJECT、SALE_CONTRACT
     * @param configId         文档配置id
     * @param createFolderName 创建文件夹名称 示例：PJ100010362205-埃林哲内部Telework5.0升级重构项目(C22026901)
     * @return {@link TwOutputUtil}<{@link BusinessDocTypePermissionPrevRecordVO}>
     */
    @GetMapping("/getYeeedocInfo")
    // @UdcNameClass
    @ApiOperation("获取yeeedoc信息")
    public TwOutputUtil<BusinessDocTypePermissionPrevRecordVO> getYeeedocInfo(Long docId, String docType, Long configId, String createFolderName) {
        BusinessDocTypePermissionPrevRecordVO businessDocTypePermissionPrevRecordVO = businessDocTypeConfigService.getYeeedocInfo(docId, docType, configId, createFolderName);
        return TwOutputUtil.ok(businessDocTypePermissionPrevRecordVO);
    }


}

