package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 通用文档-易稻壳赋权预览地址获取记录表
 *
 * @author duwh
 * @date 2023-12-09
 */
@Entity
@Table(name = "prd_business_doc_type_permission_prev_record", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_doc_type_permission_prev_record", comment = "通用文档-易稻壳赋权预览地址获取记录表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDocTypePermissionPrevRecordDO extends BaseModel implements Serializable  {
    /** 单据类型 */
    @Comment("单据类型")
    @Column()
    private String docType;
    /** 单据主键 */
    @Comment("单据主键")
    @Column()
    private Long docId;
    /** 被赋权限的人员userId */
    @Comment("被赋权限的人员userId")
    @Column()
    private Long userId;
    /** 文档类型配置主键 prd_business_doc_type_config.id */
    @Comment("文档类型配置主键 prd_business_doc_type_config.id")
    @Column()
    private Long configId;
    /** prd_business_doc_type_config_rule.id */
    @Comment("prd_business_doc_type_config_rule.id")
    @Column()
    private Long configRuleId;
    /** libraryId -yeedoc返回 */
    @Comment("libraryId -yeedoc返回")
    @Column()
    private String libraryId;
    /** 文件夹id -yeedoc返回 */
    @Comment("文件夹id -yeedoc返回")
    @Column()
    private String folderId;
    /** 文件夹名称 LeafName -yeedoc返回 */
    @Comment("文件夹名称 LeafName -yeedoc返回")
    @Column()
    private String folderName;
    /** 易稻壳文件路径 */
    @Comment("易稻壳文件路径")
    @Column(length = 1000)
    private String itemPath;
    /** 易稻壳文件预览地址 */
    @Comment("易稻壳文件预览地址")
    @Column(length = 5000)
    private String previewUri;
    /** 赋权标记 */
    @Comment("赋权标记")
    @Column()
    private Boolean permissionFlag;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessDocTypePermissionPrevRecordDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
