package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigRoleRefPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigRoleRefQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigRoleRefService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigRoleRefVO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeConfigRoleRefConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigRoleRefDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigRoleRefDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigRoleRefRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 通用文档配置 业务类型访问权限
 *
 * @author duwh
 * @date 2023-12-11
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDocTypeConfigRoleRefServiceImpl extends BaseServiceImpl implements BusinessDocTypeConfigRoleRefService {

    private final BusinessDocTypeConfigRoleRefRepo businessDocTypeConfigRoleRefRepo;
    private final BusinessDocTypeConfigRoleRefDAO businessDocTypeConfigRoleRefDAO;

    @Override
    public PagingVO<BusinessDocTypeConfigRoleRefVO> queryPaging(BusinessDocTypeConfigRoleRefQuery query) {
        return businessDocTypeConfigRoleRefDAO.queryPaging(query);
    }

    @Override
    public List<BusinessDocTypeConfigRoleRefVO> queryListDynamic(BusinessDocTypeConfigRoleRefQuery query) {
        return businessDocTypeConfigRoleRefDAO.queryListDynamic(query);
    }

    @Override
    public Long count(BusinessDocTypeConfigRoleRefQuery query) {
        return businessDocTypeConfigRoleRefDAO.count(query);
    }

    @Override
    public BusinessDocTypeConfigRoleRefVO queryByKey(Long key) {
        BusinessDocTypeConfigRoleRefDO entity = businessDocTypeConfigRoleRefRepo.findById(key).orElseGet(BusinessDocTypeConfigRoleRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeConfigRoleRefVO vo = BusinessDocTypeConfigRoleRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigRoleRefVO insert(BusinessDocTypeConfigRoleRefPayload payload) {
        BusinessDocTypeConfigRoleRefDO entityDo = BusinessDocTypeConfigRoleRefConvert.INSTANCE.toDo(payload);
        return BusinessDocTypeConfigRoleRefConvert.INSTANCE.toVo(businessDocTypeConfigRoleRefRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigRoleRefVO update(BusinessDocTypeConfigRoleRefPayload payload) {
        BusinessDocTypeConfigRoleRefDO entity = businessDocTypeConfigRoleRefRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigRoleRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeConfigRoleRefDO entityDo = BusinessDocTypeConfigRoleRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeConfigRoleRefConvert.INSTANCE.toVo(businessDocTypeConfigRoleRefRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessDocTypeConfigRoleRefPayload payload) {
        BusinessDocTypeConfigRoleRefDO entity = businessDocTypeConfigRoleRefRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigRoleRefDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessDocTypeConfigRoleRefDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDocTypeConfigRoleRefDAO.deleteSoft(keys);
        }
    }

}
