package com.elitesland.tw.tw5.server.common.permission.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Author Quruiqizz
 * @Date 2023/10/30 9:34
 **/
@Getter
@AllArgsConstructor
public enum PermissionLevelScopeEnum {

    /**
     * 组织level
     */
    ORG_PRINCIPAL("ORG_PRINCIPAL", "组织负责人"),
    ALL_USERS_IN_ORGANIZATION("ALL_USERS_IN_ORGANIZATION", "本级组织下的所有用户"),
    ALL_USERS_IN_ORGANIZATION_AND_LOWER_LEVELS("ALL_USERS_IN_ORGANIZATION_AND_LOWER_LEVELS", "本级组织及下级组织下的所有用户"),

    /**
     * 业务对象类型level
     */
    FILED_ROLE_USER("FILED_ROLE_USER", "字段角色用户"),
    FIELD_ROLE_AND_IMMEDIATE_SUPERIOR_USER("FIELD_ROLE_AND_IMMEDIATE_SUPERIOR_USER", "字段角色及直属上级用户"),
    FIELD_ROLES_AND_ALL_UPPER_LEVEL_USERS("FIELD_ROLES_AND_ALL_UPPER_LEVEL_USERS", "字段角色及所有上级用户"),
    FIELD_ROLES_AND_ALL_SUBORDINATE_USERS("FIELD_ROLES_AND_ALL_SUBORDINATE_USERS", "字段角色及所有下级用户"),

    /**
     * 角色下的level
     */
    ASSIGN_ORG_ROLES("ASSIGN_ORG_ROLES", "指定组织角色"),
    UNIVERSAL_ORG_ROLES("UNIVERSAL_ORG_ROLES", "通用组织角色")
    ;

    private final String name;

    private final String desc;

}
