package com.elitesland.tw.tw5.server.common.permission.strategy.execute;

import cn.hutool.core.text.CharSequenceUtil;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionRuleVO;
import com.elitesland.tw.tw5.server.common.permission.strategy.BusinessObjectTypeStrategyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Author Quruiqizz
 * @Date 2023/11/9 13:45
 **/
@Service(value = "BUSINESS_OBJECT_TYPE_FIELD_ROLES_AND_ALL_SUBORDINATE_USERS")
public class BusinessObjectTypeFieldRolesAndAllSubUsers implements BusinessObjectTypeStrategyService {

    @Lazy
    @Autowired
    private PrdOrgEmployeeService orgEmployeeService;

    /**
     *字段角色及所有下级用户
     *
     * @param rule
     * @param mapBuilder
     * @param ruleGroupExprList
     * @param loginUserId
     * @param defaultOrgId
     * @param childOrgIdSet
     * @param map
     * @return
     */
    @Override
    public boolean execute(PrdSystemPermissionRuleVO rule, MapBuilder mapBuilder, List<String> ruleGroupExprList, Long loginUserId, Long defaultOrgId, Set<Long> childOrgIdSet, Map<String, Object> map) {

        mapBuilder.group(rule.getRuleCode());

        Set<Long> employeeSet = new HashSet<>();
        // 首先能看到自己的
        employeeSet.add(loginUserId);

        // 查询本级 及所有下级
        List<PrdOrgEmployeeRefVO> orgEmployees = orgEmployeeService.queryLowChildListByKey(null, loginUserId);

        // 拿到下级数据
        orgEmployees.forEach(emp -> {
            employeeSet.add(emp.getUserId());
        });

        // 拼装条件
        mapBuilder.field(CharSequenceUtil.toCamelCase(rule.getRuleScope()), employeeSet).op(FieldOps.InList);

        return true;
    }

}
