package com.elitesland.tw.tw5.server.common.workFlow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.workflow.params.TaskNodeConfigDTO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping(WorkflowConstant.WORKFLOW + "{procDefKey}" + WorkflowConstant.CALLBACK)
public class CommonWorkflowCallbackController implements WorkflowCallBack {

    public static final String SERVICE_NAME_PREFIX = "TW_WORKFLOW_CALLBACK_";
    private final WorkflowService workflowService;

    @Autowired
    private Map<String, WorkflowCallBack> workflowCallBackMap;

    @Autowired
    private Map<String, CommonWorkflowEvent> workflowEventMap;

    @Autowired
    private Map<String, CommonWorkflowCheck> workflowCheckMap;


    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("taskAssignee:{}", payload);
        String procDefKey = payload.getProcDefKey();
        // 进行通用处理
        // 有没有子类的实现，如果有，按照子类的代码处理业务
        WorkflowCallBack workflowCallBack = workflowCallBackMap.get(SERVICE_NAME_PREFIX+procDefKey);
        if (workflowCallBack != null) {
            return workflowCallBack.taskAssignee(payload);
        }

        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("taskCreated:{}", payload);

        // -------------  进行通用处理  -------------
        // 进行检查处理
        WorkflowResult<List<TaskNodeConfigDTO>> nodeConfig = workflowService.getNodeConfig(payload.getProcDefKey(), payload.getTaskKey());
        if (nodeConfig.isSuccess()){
            List<TaskNodeConfigDTO> taskNodes = nodeConfig.getData();
            if(taskNodes != null && !taskNodes.isEmpty()){
                TaskNodeConfigDTO taskNodeConfigDTO = taskNodes.get(0);
                String checkString = taskNodeConfigDTO.getEs1();
                JSONArray jsonArray = JSON.parseArray(checkString);
                if(jsonArray != null && !jsonArray.isEmpty()){
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject checkObject = jsonArray.getJSONObject(i);
                        String checkName = checkObject.getString("checkName");
                        String checkCode = checkObject.getString("checkCode");
                        String checkParams = checkObject.getString("checkParams");
                        log.info("执行工作流检查：【名称：{}】【参数：{}】", checkName, checkCode );
                        CommonWorkflowCheck workflowCheck = workflowCheckMap.get(CommonWorkflowCheck.SERVICE_NAME_PREFIX+checkCode);
                        workflowCheck.setProps(payload,checkParams.split(","));
                        TwOutputUtil result = workflowCheck.check();
                        if (!result.isSuccess()){
                            return new WorkflowResult<>(false, result.getMsg(), null);
                        }
                    }
                }
            }
        }
        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("taskCompleted:{}", payload);
        String procDefKey = payload.getProcDefKey();
        String taskKey = payload.getTaskKey();
        // -------------  进行通用处理  -------------
        // 进行事件处理
        WorkflowResult<List<TaskNodeConfigDTO>> nodeConfig = workflowService.getNodeConfig(procDefKey, taskKey);
        if (nodeConfig.isSuccess()){
            List<TaskNodeConfigDTO> taskNodes = nodeConfig.getData();
            if(taskNodes != null && !taskNodes.isEmpty()){
                TaskNodeConfigDTO taskNodeConfigDTO = taskNodes.get(0);
                String eventString = taskNodeConfigDTO.getEs2();
                JSONArray jsonArray = JSON.parseArray(eventString);
                if(jsonArray != null && !jsonArray.isEmpty()){
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject checkObject = jsonArray.getJSONObject(i);
                        String eventName = checkObject.getString("eventName");
                        String eventCode = checkObject.getString("eventCode");
                        String eventParams = checkObject.getString("eventParams");
                        log.info("执行工作流事件：【名称：{}】【参数：{}】", eventName, eventParams );
                        CommonWorkflowEvent workflowEvent = workflowEventMap.get(CommonWorkflowEvent.SERVICE_NAME_PREFIX+eventCode);
                        workflowEvent.setProps(payload,eventParams.split(","));
                        workflowEvent.execute();
                    }
                }
            }
        }

        // -------------  调用自定义业务处理  -------------
        // 有没有子类的实现，如果有，按照子类的代码处理业务
        WorkflowCallBack workflowCallBack = workflowCallBackMap.get(SERVICE_NAME_PREFIX+procDefKey);
        if (workflowCallBack != null) {
            return workflowCallBack.taskCompleted(payload);
        }

        return WorkflowResult.success(null);
    }

    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("processStatusChange:{}", payload);
        String procDefKey = payload.getProcDefKey();
        // 进行通用处理
        // 有没有子类的实现，如果有，按照子类的代码处理业务
        WorkflowCallBack workflowCallBack = workflowCallBackMap.get(SERVICE_NAME_PREFIX+procDefKey);
        if (workflowCallBack != null) {
            return workflowCallBack.processStatusChange(payload);
        }
        return WorkflowResult.success(null);
    }
}
