package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimRulePayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimRuleQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimRuleService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimRuleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报销规则管理
 *
 * @author sunxw
 * @date 2023-12-03
 */
@Api(tags = "报销规则管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accReimRule")
@Slf4j
public class AccReimRuleController {

    private final AccReimRuleService accReimRuleService;

    /**
     * 报销规则管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销规则管理-新增")
    public TwOutputUtil<AccReimRuleVO> insert(@RequestBody AccReimRulePayload payload) {
        return TwOutputUtil.ok(accReimRuleService.insert(payload));
    }

    /**
     * 报销规则管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销规则管理-更新")
    public TwOutputUtil<AccReimRuleVO> update(@RequestBody AccReimRulePayload payload) {
        return TwOutputUtil.ok(accReimRuleService.update(payload));
    }

    /**
     * 报销规则管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销规则管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimRulePayload payload) {
        return TwOutputUtil.ok(accReimRuleService.updateByKeyDynamic(payload));
    }

    /**
     * 报销规则管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销规则管理-主键查询")
    public TwOutputUtil<AccReimRuleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimRuleService.queryByKey(key));
    }

    /**
     * 报销规则管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("报销规则管理-分页")
    public TwOutputUtil<PagingVO<AccReimRuleVO>> paging(AccReimRuleQuery query) {
        return TwOutputUtil.ok(accReimRuleService.queryPaging(query));
    }

    /**
     * 报销规则管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("报销规则管理-查询列表")
    public TwOutputUtil<List<AccReimRuleVO>> queryList(AccReimRuleQuery query) {
        return TwOutputUtil.ok(accReimRuleService.queryListDynamic(query));
    }

    /**
     * 报销规则管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销规则管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimRuleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

