package com.elitesland.tw.tw5.server.prd.acc.controller;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverdueDiscuntPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueDiscuntQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueDiscuntService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueDiscuntVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报销逾期打折表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Api(tags = "报销逾期打折表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/accReimSettingOverdueDiscunt")
@Slf4j
public class AccReimSettingOverdueDiscuntController {

private final AccReimSettingOverdueDiscuntService accReimSettingOverdueDiscuntService;

    /**
     * 报销逾期打折表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销逾期打折表-新增")
    public TwOutputUtil<AccReimSettingOverdueDiscuntVO> insert(@RequestBody AccReimSettingOverdueDiscuntPayload payload){
         return TwOutputUtil.ok(accReimSettingOverdueDiscuntService.insert(payload));
    }

    /**
     * 报销逾期打折表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销逾期打折表-更新")
    public TwOutputUtil<AccReimSettingOverdueDiscuntVO> update(@RequestBody AccReimSettingOverdueDiscuntPayload payload){
        return TwOutputUtil.ok(accReimSettingOverdueDiscuntService.update(payload));
    }

    /**
     * 报销逾期打折表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销逾期打折表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AccReimSettingOverdueDiscuntPayload payload){
        return TwOutputUtil.ok(accReimSettingOverdueDiscuntService.updateByKeyDynamic(payload));
    }

    /**
     * 报销逾期打折表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销逾期打折表-主键查询")
    public TwOutputUtil<AccReimSettingOverdueDiscuntVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimSettingOverdueDiscuntService.queryByKey(key));
    }

    /**
     * 报销逾期打折表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("报销逾期打折表-分页")
    public TwOutputUtil<PagingVO<AccReimSettingOverdueDiscuntVO>> paging(AccReimSettingOverdueDiscuntQuery query) {
        return TwOutputUtil.ok(accReimSettingOverdueDiscuntService.queryPaging(query));
    }

    /**
     * 报销逾期打折表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销逾期打折表-查询列表")
    public TwOutputUtil<List<AccReimSettingOverdueDiscuntVO>> queryList(AccReimSettingOverdueDiscuntQuery query) {
        return TwOutputUtil.ok(accReimSettingOverdueDiscuntService.queryListDynamic(query));
    }

    /**
     * 报销逾期打折表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销逾期打折表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         accReimSettingOverdueDiscuntService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

