package com.elitesland.tw.tw5.server.prd.acc.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimDetailMealPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimDetailMealQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimDetailMealService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailMealVO;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceNormalQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceNormalService;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceRuleService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.TAttendanceNormalVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimDetailMealConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDetailMealDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimDetailMealDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimDetailMealRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.util.*;

/**
 * 报销明细餐费记录
 *
 * @author zoey
 * @date 2024-06-12
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimDetailMealServiceImpl extends BaseServiceImpl implements AccReimDetailMealService {

    private final AccReimDetailMealRepo accReimDetailMealRepo;
    private final AccReimDetailMealDAO accReimDetailMealDAO;
    private final VacationService vacationService;
    private final TAttendanceRuleService attendanceRuleService;
    private final TAttendanceNormalService attendanceNormalService;
    private final FileUtil fileUtil;

    @Override
    public PagingVO<AccReimDetailMealVO> queryPaging(AccReimDetailMealQuery query) {
        return accReimDetailMealDAO.queryPaging(query);
    }


    @Override
    public List<AccReimDetailMealVO> queryListDynamic(AccReimDetailMealQuery query) {
        List<AccReimDetailMealVO> reimDetailMealVOS = accReimDetailMealDAO.queryListDynamic(query);
        for (AccReimDetailMealVO reimDetailMealVO : reimDetailMealVOS) {
            //附件信息
            if (!ObjectUtils.isEmpty(reimDetailMealVO.getFileCode())) {
                Object fileData = fileUtil.getFileDatas(reimDetailMealVO.getFileCode());
                reimDetailMealVO.setFileData(fileData);
            }
        }
        return reimDetailMealVOS;
    }

    @Override
    public List<AccReimDetailMealVO> queryListInit(AccReimDetailMealQuery query) {
        // 查询当前登录人userId
        Long userId = query.getUserId() == null ? GlobalUtil.getLoginUserId() : query.getUserId();
        List<LocalDate> mealDate = query.getMealDate();
        if (CollectionUtils.isEmpty(mealDate)) {
            throw TwException.error("", "请选择日期区间");
        } else {
            // 查询日期区间内的法定假期列表
            List<LocalDate> vacationDays = vacationService.findVacationDay(mealDate.get(0), mealDate.get(1));
            // 查询日期区间内的打卡列表
            TAttendanceNormalQuery attendanceNormalQuery = new TAttendanceNormalQuery();
            attendanceNormalQuery.setAttendanceResId(userId);
            attendanceNormalQuery.setAttendanceDates(mealDate);
            List<TAttendanceNormalVO> tAttendanceNormalVOS = attendanceNormalService.queryListDynamic(attendanceNormalQuery);
            List<AccReimDetailMealVO> reimDetailMealVOS = new ArrayList<>();
            if (!CollectionUtils.isEmpty(vacationDays)) {
                for (LocalDate vacationDay : vacationDays) {
                    AccReimDetailMealVO accReimDetailMealVO = new AccReimDetailMealVO();
                    accReimDetailMealVO.setMealDate(vacationDay);
                    reimDetailMealVOS.add(accReimDetailMealVO);
                }
            }
            if (!CollectionUtils.isEmpty(tAttendanceNormalVOS)) {
                for (TAttendanceNormalVO attendanceNormalVO : tAttendanceNormalVOS) {
                    AccReimDetailMealVO accReimDetailMealVO = new AccReimDetailMealVO();
                    // 校验是否被占用了
                    if (attendanceNormalVO.getAttendanceTimeEnd() != null && Integer.parseInt(attendanceNormalVO.getAttendanceTimeEnd().split(":")[0]) > 20) {
                        accReimDetailMealVO.setMealDate(attendanceNormalVO.getAttendanceDate());
                        accReimDetailMealVO.setAttendanceId(attendanceNormalVO.getId());
                        accReimDetailMealVO.setAttendanceTimeStart(attendanceNormalVO.getAttendanceTimeStart());
                        accReimDetailMealVO.setAttendanceTimeEnd(attendanceNormalVO.getAttendanceTimeEnd());
                        accReimDetailMealVO.setAttendanceCity(attendanceNormalVO.getAttendanceCity());// 打卡城市
                        reimDetailMealVOS.add(accReimDetailMealVO);
                    }
                }
            }
            // 对两个列表进行合并，去重，排序,打卡数据优先
            Collections.sort(reimDetailMealVOS, new Comparator<AccReimDetailMealVO>() {
                @Override
                public int compare(AccReimDetailMealVO vo1, AccReimDetailMealVO vo2) {
                    return vo1.getMealDate().compareTo(vo2.getMealDate());
                }
            });

            // 去重并保留指定条件的记录
            Set<LocalDate> uniqueMealDates = new HashSet<>();
            List<AccReimDetailMealVO> sortedAndDistinctList = new ArrayList<>();

            for (AccReimDetailMealVO vo : reimDetailMealVOS) {
                if (vo.getAttendanceId() == null || uniqueMealDates.add(vo.getMealDate())) {
                    sortedAndDistinctList.add(vo);
                }
            }
            return sortedAndDistinctList;
        }
    }

    @Override
    public AccReimDetailMealVO queryByKey(Long key) {
        AccReimDetailMealDO entity = accReimDetailMealRepo.findById(key).orElseGet(AccReimDetailMealDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimDetailMealVO vo = AccReimDetailMealConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimDetailMealVO insert(AccReimDetailMealPayload payload) {
        AccReimDetailMealDO entityDo = AccReimDetailMealConvert.INSTANCE.toDo(payload);
        return AccReimDetailMealConvert.INSTANCE.toVo(accReimDetailMealRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<AccReimDetailMealVO> insertList(List<AccReimDetailMealPayload> payloads) {
        List<AccReimDetailMealDO> entityDos = AccReimDetailMealConvert.INSTANCE.toDoList(payloads);
        return AccReimDetailMealConvert.INSTANCE.toVoList(accReimDetailMealRepo.saveAll(entityDos));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimDetailMealVO update(AccReimDetailMealPayload payload) {
        AccReimDetailMealDO entity = accReimDetailMealRepo.findById(payload.getId()).orElseGet(AccReimDetailMealDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimDetailMealDO entityDo = AccReimDetailMealConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimDetailMealConvert.INSTANCE.toVo(accReimDetailMealRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AccReimDetailMealPayload payload) {
        AccReimDetailMealDO entity = accReimDetailMealRepo.findById(payload.getId()).orElseGet(AccReimDetailMealDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = accReimDetailMealDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            accReimDetailMealDAO.deleteSoft(keys);
        }
    }

}
