package com.elitesland.tw.tw5.server.prd.adm.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 出差申请管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Api(tags = "出差申请管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/adm/admBusitripApply")
@Slf4j
public class AdmBusitripApplyController {

    private final AdmBusitripApplyService admBusitripApplyService;

    /**
     * 出差申请管理-新增或编辑
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("出差申请管理-新增")
    public TwOutputUtil<AdmBusitripApplyVO> insertOrUpdate(@RequestBody AdmBusitripApplyPayload payload) {
        return TwOutputUtil.ok(admBusitripApplyService.insertOrUpdate(payload));
    }
//
//    /**
//     * 出差申请管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("出差申请管理-更新")
//    public TwOutputUtil<AdmBusitripApplyVO> update(@RequestBody AdmBusitripApplyPayload payload) {
//        return TwOutputUtil.ok(admBusitripApplyService.update(payload));
//    }

//    /**
//     * 出差申请管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping("update")
//    @ApiOperation("出差申请管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
//    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody AdmBusitripApplyPayload payload) {
//        return TwOutputUtil.ok(admBusitripApplyService.updateByKeyDynamic(payload));
//    }

    /**
     * 出差申请管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("出差申请管理-主键查询")
    public TwOutputUtil<AdmBusitripApplyVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(admBusitripApplyService.queryByKey(key));
    }

    /**
     * 出差申请管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("出差申请管理-分页")
    public TwOutputUtil<PagingVO<AdmBusitripApplyVO>> paging(AdmBusitripApplyQuery query) {
        return TwOutputUtil.ok(admBusitripApplyService.queryPaging(query));
    }

    /**
     * 出差申请管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("出差申请管理-查询列表")
    public TwOutputUtil<List<AdmBusitripApplyVO>> queryList(AdmBusitripApplyQuery query) {
        return TwOutputUtil.ok(admBusitripApplyService.queryListDynamic(query));
    }

    /**
     * 出差申请管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("出差申请管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        admBusitripApplyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

