package com.elitesland.tw.tw5.server.prd.budget.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetSubjectDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetSubjectDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetSubjectDetailService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetSubjectDetailConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetSubjectDetailDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetSubjectDetailDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetSubjectDetailRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.ArrayList;
import java.util.List;

/**
 * 预算科目明细
 *
 * @author xxb
 * @date 2023-11-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BudgetSubjectDetailServiceImpl extends BaseServiceImpl implements BudgetSubjectDetailService {

    private final BudgetSubjectDetailRepo budgetSubjectDetailRepo;
    private final BudgetSubjectDetailDAO budgetSubjectDetailDAO;

    @Override
    public void batchSave(List<BudgetSubjectDetailPayload> subjectDetailPayloads) {
        List<BudgetSubjectDetailDO> sudgetSubjectDetailDOs = new ArrayList<>();
        for (BudgetSubjectDetailPayload payload : subjectDetailPayloads) {
            sudgetSubjectDetailDOs.add(BudgetSubjectDetailConvert.INSTANCE.toDo(payload));
        }
        budgetSubjectDetailDAO.saveAll(sudgetSubjectDetailDOs);
    }

    @Override
    public List<BudgetSubjectDetailVO> queryListDyBudgetId(Long budgetId) {
        BudgetSubjectDetailQuery query = new BudgetSubjectDetailQuery();
        query.setBudgetId(budgetId);
        return budgetSubjectDetailDAO.queryListDynamic(query);
    }

    @Override
    public PagingVO<BudgetSubjectDetailVO> queryPaging(BudgetSubjectDetailQuery query) {
        return budgetSubjectDetailDAO.queryPaging(query);
    }

    @Override
    public List<BudgetSubjectDetailVO> queryListDynamic(BudgetSubjectDetailQuery query) {
        return budgetSubjectDetailDAO.queryListDynamic(query);
    }

    @Override
    public BudgetSubjectDetailVO queryByKey(Long key) {
        BudgetSubjectDetailDO entity = budgetSubjectDetailRepo.findById(key).orElseGet(BudgetSubjectDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BudgetSubjectDetailVO vo = BudgetSubjectDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BudgetSubjectDetailVO insert(BudgetSubjectDetailPayload payload) {
        BudgetSubjectDetailDO entityDo = BudgetSubjectDetailConvert.INSTANCE.toDo(payload);
        return BudgetSubjectDetailConvert.INSTANCE.toVo(budgetSubjectDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BudgetSubjectDetailVO update(BudgetSubjectDetailPayload payload) {
        BudgetSubjectDetailDO entity = budgetSubjectDetailRepo.findById(payload.getId()).orElseGet(BudgetSubjectDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BudgetSubjectDetailDO entityDo = BudgetSubjectDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BudgetSubjectDetailConvert.INSTANCE.toVo(budgetSubjectDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BudgetSubjectDetailPayload payload) {
        BudgetSubjectDetailDO entity = budgetSubjectDetailRepo.findById(payload.getId()).orElseGet(BudgetSubjectDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = budgetSubjectDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            budgetSubjectDetailDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long deleteSoftByBudgetId(Long budgetId) {
        return budgetSubjectDetailDAO.deleteSoftByBudgetId(budgetId);
    }

}
