package com.elitesland.tw.tw5.server.prd.cas.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * cas_setting
 *
 * @author zoey
 * @date 2024-01-25
 */
@Entity
@Table(name = "prd_cas_setting", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_cas_setting", comment = "cas_setting")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdCasSettingDO extends BaseModel implements Serializable  {
    /** 应用识别码 */
    @Comment("应用识别码")
    @Column()
    private String appId;
    /** JWT签名key */
    @Comment("JWT签名key")
    @Column()
    private String secret;
    /** 交叉认证接口 */
    @Comment("交叉认证接口")
    @Column()
    private String validateUri;
    /** 跳转页面 */
    @Comment("跳转页面")
    @Column()
    private String redirectUri;
    /** 请求头信息 */
    @Comment("请求头信息")
    @Column()
    private String requestHeaders;

    public void copy(PrdCasSettingDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
