package com.elitesland.tw.tw5.server.prd.copartner.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 合伙人绩效考核点维护
 *
 * @author carl
 * @date 2024-06-24
 */
@Entity
@Table(name = "performance_readme_config_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "performance_readme_config_detail", comment = "合伙人绩效考核点维护")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PerformanceReadmeConfigDetailDO extends BaseModel implements Serializable {
    /**
     * 配置主键
     */
    @Comment("配置主键")
    @Column()
    private Long configId;
    /**
     * 考核来源
     */
    @Comment("考核来源")
    @Column()
    private String detailSource;
    /**
     * 考核点
     */
    @Comment("考核点")
    @Column()
    private String detailPod;
    /**
     * 详情状态
     */
    @Comment("详情状态")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer detailStatus;
    /**
     * 详情类型
     */
    @Comment("详情类型")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer detailType;

    public void copy(PerformanceReadmeConfigDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
