package com.elitesland.tw.tw5.server.prd.crm.amap.controller;

import com.elitesland.tw.tw5.api.prd.crm.amap.query.AmapAroundQuery;
import com.elitesland.tw.tw5.api.prd.crm.amap.query.AmapTextQuery;
import com.elitesland.tw.tw5.api.prd.crm.amap.serivce.AmapSerivce;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;

import com.elitesland.tw.tw5.server.common.dto.gaode.GaoDeRoot;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 *  高德接口
 *
 * @author duwh
 * @date 2023-05-22
 */
@Api(tags = "高德接口")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/amap")
@Slf4j
public class AmapController {

    private final AmapSerivce amapSerivce;

    /**
     * 高德接口-附近客户列表(周边搜索)
     *
     * https://lbs.amap.com/api/webservice/guide/api/search/#around
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("around")
    @ApiOperation("高德接口-附近客户列表(周边搜索)")
    public TwOutputUtil<GaoDeRoot> around(AmapAroundQuery query) {
        return TwOutputUtil.ok(amapSerivce.around(query));
    }

    /**
     * 关键字搜索
     *
     * https://lbs.amap.com/api/webservice/guide/api/search/#text
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/text")
    @ApiOperation("关键字搜索")
    public TwOutputUtil<GaoDeRoot> text(AmapTextQuery query) {
        return TwOutputUtil.ok(amapSerivce.text(query));
    }

    /**
     * 高德接口-附近客户列表Demo(周边搜索)
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("aroundDemo")
    @ApiOperation("高德接口-附近客户列表(周边搜索)Demo")
    public String aroundDemo(AmapAroundQuery query) {
        return "{\n" +
            "    \"ok\": true,\n" +
            "    \"data\": {\n" +
            "        \"suggestion\": {\n" +
            "            \"keywords\": [\n" +
            "                \n" +
            "            ],\n" +
            "            \"cities\": [\n" +
            "                \n" +
            "            ]\n" +
            "        },\n" +
            "        \"count\": \"879\",\n" +
            "        \"infocode\": \"10000\",\n" +
            "        \"pois\": [\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.01\",\n" +
            "                \"parent\": \"B0IA9HM2E6\",\n" +
            "                \"address\": \"龙宇国际1216-1219\",\n" +
            "                \"distance\": \"9\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/38743e481f194e8399b043e4dc9bfe34\"\n" +
            "                    },\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/afb5f54d8a2b4d26b51c968b551fe941\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"郑州埃林哲软件系统有限公司\",\n" +
            "                \"location\": \"113.767410,34.755572\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0H397S2SR\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.013\",\n" +
            "                \"parent\": \"B0173185SB\",\n" +
            "                \"address\": \"东风南路与商鼎路交叉口东北角龙宇国际14层\",\n" +
            "                \"distance\": \"12\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/09c38e052c8008ff50e5e30ed57f1097\"\n" +
            "                    },\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/3e461886391f1b83f1b63dd4e735770a\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"1\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"微盟郑州分公司\",\n" +
            "                \"location\": \"113.767639,34.755631\",\n" +
            "                \"tel\": \"18637193007\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0FFKYOLR1\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.025\",\n" +
            "                \"parent\": \"B0173185SB\",\n" +
            "                \"address\": \"商鼎路东风南路龙宇国际13楼\",\n" +
            "                \"distance\": \"25\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"郑州心之语教育信息咨询有限公司\",\n" +
            "                \"location\": \"113.767695,34.755776\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0GKPGVQXC\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.028\",\n" +
            "                \"parent\": \"B0IA9HM2E6\",\n" +
            "                \"address\": \"东风路街道龙宇国际15层1516室\",\n" +
            "                \"distance\": \"28\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"4.0\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/27a42b437c5c612a9d745d707dc82a1d\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"1\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"震坤行工业超市-郑州办公室\",\n" +
            "                \"location\": \"113.767737,34.755782\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0G0N7XQZZ\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.034\",\n" +
            "                \"parent\": \"B0IA9HM2E6\",\n" +
            "                \"address\": \"商鼎路与东风路交叉口西北角龙宇国际1010\",\n" +
            "                \"distance\": \"33\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;网络科技\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/8a7decaedac446a90823d430c5af98b5\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170206\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"厦门亿联网络技术股份有限公司河南办事处\",\n" +
            "                \"location\": \"113.767869,34.755646\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0IDVCFB4I\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.035\",\n" +
            "                \"parent\": \"B0IA9HM2E6\",\n" +
            "                \"address\": \"东风南路商鼎路龙宇国际13层\",\n" +
            "                \"distance\": \"34\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/272bd8c972a66d05bafaddb131589feb\"\n" +
            "                    },\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/1b554d5dfaadf11be14abde9f3c488c6\"\n" +
            "                    },\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/ab81515c0f0240b875a1903f8f5695ae\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"1\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"趁年轻商标事务所(郑州)有限公司\",\n" +
            "                \"location\": \"113.767877,34.755558\",\n" +
            "                \"tel\": \"13213180305;15544180305\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0I2JC34NQ\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.038\",\n" +
            "                \"parent\": \"B0IA9HM2E6\",\n" +
            "                \"address\": \"龙宇国际\",\n" +
            "                \"distance\": \"37\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"河南能源化工集团有限公司(销售总公司)\",\n" +
            "                \"location\": \"113.767845,34.755805\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0J607CTB9\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.04\",\n" +
            "                \"parent\": \"B0173185SB\",\n" +
            "                \"address\": \"龙宇国际521室\",\n" +
            "                \"distance\": \"39\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/bd5485029161bb81c5d4cc6d076eaa63\"\n" +
            "                    },\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/107c416075d014d88e027bb3dab891a2\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"1\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"深蓝酒店有限公司\",\n" +
            "                \"location\": \"113.767784,34.755886\",\n" +
            "                \"tel\": \"0371-66672226\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0HGK5HQO1\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.04\",\n" +
            "                \"parent\": \"B0IA9HM2E6\",\n" +
            "                \"address\": \"龙宇国际A栋\",\n" +
            "                \"distance\": \"39\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"河南甯轩商务服务有限公司\",\n" +
            "                \"location\": \"113.767821,34.755859\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0G1P4JBW4\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.041\",\n" +
            "                \"parent\": \"B0173185SB\",\n" +
            "                \"address\": \"郑东新区龙宇国际8层804号\",\n" +
            "                \"distance\": \"40\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"金融保险服务;保险公司;保险公司\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/680fcba33c9f9d7c24803dc3415e03d9\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"160400\",\n" +
            "                \"shopinfo\": \"2\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"复星集团星恒保险代理有限责任公司河南分公司\",\n" +
            "                \"location\": \"113.767800,34.755887\",\n" +
            "                \"tel\": \"0371-55570058\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0HDY5Q3VU\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.041\",\n" +
            "                \"parent\": \"B0IA9HM2E6\",\n" +
            "                \"address\": \"商都路龙宇国际818\",\n" +
            "                \"distance\": \"41\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/e676c8d912fa3cf62d8c8b603ccb6356\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"易享物联网陪护平台中部运营中心\",\n" +
            "                \"location\": \"113.767795,34.755896\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0H0CUUZG4\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.041\",\n" +
            "                \"parent\": \"B0173185SB\",\n" +
            "                \"address\": \"郑东新区东风南路商鼎路口龙宇国际1015室\",\n" +
            "                \"distance\": \"41\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"公正工程管理咨询有限公司\",\n" +
            "                \"location\": \"113.767830,34.755871\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0FFJO6KAN\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.042\",\n" +
            "                \"parent\": \"B0173185SB\",\n" +
            "                \"address\": \"东风南路商鼎路龙宇国际13层\",\n" +
            "                \"distance\": \"41\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/5aa85915a07d900e893ef0e81cc26ba1\"\n" +
            "                    },\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/59b80eae9623582b00b0026cf1f29791\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"郑州博福机电设备安装有限公司\",\n" +
            "                \"location\": \"113.767793,34.755903\",\n" +
            "                \"tel\": \"15290969279\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0IDCDVWMH\"\n" +
            "            },\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": \"0.059\",\n" +
            "                \"parent\": \"B0IA9HM2E6\",\n" +
            "                \"address\": \"东风南路商鼎路龙宇国际\",\n" +
            "                \"distance\": \"58\",\n" +
            "                \"pname\": \"河南省\",\n" +
            "                \"importance\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"郑州市\",\n" +
            "                \"type\": \"公司企业;公司;网络科技\",\n" +
            "                \"photos\": [\n" +
            "                    {\n" +
            "                        \"title\": [\n" +
            "                            \n" +
            "                        ],\n" +
            "                        \"url\": \"http://store.is.autonavi.com/showpic/5e28092aa95b4a4c50ce152f66150983\"\n" +
            "                    }\n" +
            "                ],\n" +
            "                \"typecode\": \"170206\",\n" +
            "                \"shopinfo\": \"1\",\n" +
            "                \"poiweight\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"管城回族区\",\n" +
            "                \"name\": \"河南众脸物联网科技有限公司\",\n" +
            "                \"location\": \"113.768082,34.755841\",\n" +
            "                \"tel\": \"13213196797\",\n" +
            "                \"shopid\": [\n" +
            "                    \n" +
            "                ],\n" +
            "                \"id\": \"B0FFMA2298\"\n" +
            "            }\n" +
            "        ],\n" +
            "        \"status\": \"1\",\n" +
            "        \"info\": \"OK\"\n" +
            "    },\n" +
            "    \"infos\": [\n" +
            "        {\n" +
            "            \"localeCode\": \"COM-SUCCESS\",\n" +
            "            \"msg\": \"操作成功\",\n" +
            "            \"defaultMsg\": \"操作成功\",\n" +
            "            \"context\": null\n" +
            "        }\n" +
            "    ],\n" +
            "    \"errors\": [\n" +
            "        \n" +
            "    ],\n" +
            "    \"warns\": [\n" +
            "        \n" +
            "    ]\n" +
            "}";
    }

    /**
     * 关键字搜索 Demo
     *
     * https://lbs.amap.com/api/webservice/guide/api/search/#text
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/textDemo")
    @ApiOperation("关键字搜索 Demo")
    public String textDemo(AmapTextQuery query) {
        return "{\n" +
            "    \"ok\": true,\n" +
            "    \"data\": {\n" +
            "        \"suggestion\": {\n" +
            "            \"keywords\": [],\n" +
            "            \"cities\": []\n" +
            "        },\n" +
            "        \"count\": \"1\",\n" +
            "        \"infocode\": \"10000\",\n" +
            "        \"pois\": [\n" +
            "            {\n" +
            "                \"customerFlag\": false,\n" +
            "                \"distanceDifference\": null,\n" +
            "                \"parent\": \"B0FFL6C2DO\",\n" +
            "                \"address\": \"上海市诸光路1588弄虹桥世界中心L2A幢7层\",\n" +
            "                \"distance\": \"[]\",\n" +
            "                \"pname\": \"上海市\",\n" +
            "                \"importance\": [],\n" +
            "                \"biz_ext\": {\n" +
            "                    \"cost\": \"[]\",\n" +
            "                    \"opentime2\": null,\n" +
            "                    \"rating\": \"[]\",\n" +
            "                    \"open_time\": null,\n" +
            "                    \"meal_ordering\": null\n" +
            "                },\n" +
            "                \"biz_type\": \"[]\",\n" +
            "                \"cityname\": \"上海市\",\n" +
            "                \"type\": \"公司企业;公司;公司\",\n" +
            "                \"photos\": [],\n" +
            "                \"typecode\": \"170200\",\n" +
            "                \"shopinfo\": \"0\",\n" +
            "                \"poiweight\": [],\n" +
            "                \"childtype\": \"202\",\n" +
            "                \"adname\": \"青浦区\",\n" +
            "                \"name\": \"上海埃林哲软件系统有限公司\",\n" +
            "                \"location\": \"121.306561,31.184722\",\n" +
            "                \"tel\": \"[]\",\n" +
            "                \"shopid\": [],\n" +
            "                \"id\": \"B0HALA2W7C\"\n" +
            "            }\n" +
            "        ],\n" +
            "        \"status\": \"1\",\n" +
            "        \"info\": \"OK\"\n" +
            "    },\n" +
            "    \"infos\": [\n" +
            "        {\n" +
            "            \"localeCode\": \"COM-SUCCESS\",\n" +
            "            \"msg\": \"操作成功\",\n" +
            "            \"defaultMsg\": \"操作成功\",\n" +
            "            \"context\": null\n" +
            "        }\n" +
            "    ],\n" +
            "    \"errors\": [],\n" +
            "    \"warns\": []\n" +
            "}";
    }


}
