package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCommonService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPotentialCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPotentialCustomerListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPotentialCustomerVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/15 - 10:14
 */
@Api("近海管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmPotentialCustomerController  {

    private final CrmPotentialCustomerService service;
    private final CrmFollowService followService;
    private final CrmCommonService crmCommonService;

    /**
     * 新建或修改
     * @param payload po类
     * @return result
     */
    @ApiOperation("新增和修改")
    @PostMapping("/potentialCustomer/saveOne")
    public TwOutputUtil insert(@RequestBody CrmPotentialCustomerPayload payload) {
        CrmPotentialCustomerVO vo = service.saveOne(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 局部字段更新
     * @param payload po类
     * @return result
     */
    @PostMapping("/potentialCustomer/dynamicUpdate")
    public TwOutputUtil dynamicUpdate(@RequestBody CrmPotentialCustomerPayload payload) {
        service.dynamicUpdate(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 省市区字段更新，需要清空值，直接修改原接口容易误清空值，故新增接口单独处理省市区修改。
     * @param payload po类
     * @return result
     */
    @PostMapping("/potentialCustomer/updateProvinceCityDistrict")
    public TwOutputUtil updateProvinceCityDistrict(@RequestBody CrmPotentialCustomerPayload payload) {
        service.updateProvinceCityDistrict(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 转移到公海
     * @param payload po类
     * @return result
     */
    @PostMapping("/potentialCustomer/transfer/opensea")
    public TwOutputUtil transferPotentialCustomerOpensea(@RequestBody CrmPotentialCustomerPayload payload) {
        service.transferPotentialCustomerOpensea(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 批量转移到公海
     * @param payloads po类
     * @return result
     */
    @PostMapping("/potentialCustomer/batchTransfer/opensea")
    public TwOutputUtil transferPotentialCustomerOpenseaBatch(@RequestBody List<CrmPotentialCustomerPayload> payloads) {
        service.transferPotentialCustomerOpenseaBatch(payloads);
        return TwOutputUtil.ok();
    }

    /**
     * 转移到近海
     * @param payload po类
     * @return result
     */
    @PostMapping("/potentialCustomer/transfer/offshore")
    public TwOutputUtil transferPotentialCustomerOffshore(@RequestBody CrmLeadsDetailPayload payload) {
        return TwOutputUtil.ok(service.transferPotentialCustomerOffshore(payload));
    }



    /**
     * 列表查询不分页(默认列表)
     * @param query 查询参数
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/potentialCustomer/list")
    public TwOutputUtil queryList(CrmPotentialCustomerQuery query) {
        List<CrmPotentialCustomerListVO> list = service.queryList(query);
        return TwOutputUtil.ok(list);
    }

    /**
     * 公海、潜在客户 分页查询
     *
     * @return result
     */
    @GetMapping("/potentialCustomer/paging")
    public TwOutputUtil paging(CrmPotentialCustomerQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 详情查询
     * @param id 主键
     * @return result
     */
    @ApiOperation("详情查询")
    @GetMapping("/potentialCustomer/detail/{id}")
    public TwOutputUtil queryDetail(@PathVariable Long id) {
        CrmPotentialCustomerVO vo= service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 逻辑删除
     * @param keys 主键
     * @return result
     */
    @ApiOperation("逻辑删除")
    @DeleteMapping("/potentialCustomer/delete")
    public TwOutputUtil delete(Long[] keys) {
        service.deletePotentialCustomerSoft(keys);
        return TwOutputUtil.ok();
    }

    /**
     * 潜在客户跟进列表
     * @param potentialCustomerId 主键id
     * @return result
     */
    @GetMapping("/potentialCustomer/follow/list")
    public TwOutputUtil queryFollowList(@RequestParam Long potentialCustomerId) {
        return TwOutputUtil.ok( followService.queryFollowList(potentialCustomerId, CrmFollowObjectEnum.Potential_customer.name()));
    }

    /**
     * 更新跟进
     * @param payload po类
     * @return result
     */
    @PostMapping("/potentialCustomer/follow/saveOne")
    public TwOutputUtil updateFollow(@RequestBody CrmFollowPayload payload) {
        service.updateFollow(payload);
        return TwOutputUtil.ok();
    }


    /**
     * 潜在客户日志列表
     * @param potentialCustomerId 主键id
     * @return result
     */
    @GetMapping("/potentialCustomer/log/list/{potentialCustomerId}")
    public TwOutputUtil queryLogList(@PathVariable Long potentialCustomerId) {
        return TwOutputUtil.ok( service.queryLogList(potentialCustomerId));
    }


    /**
     * 线索日志列表
     * @param query
     * @return result
     */
    @GetMapping("/potentialCustomer/log/paging")
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok( service.pageLog(query));
    }


    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @GetMapping("/potentialCustomer/batchExport")
    public void batchExport(HttpServletResponse response, CrmPotentialCustomerQuery query) {
        service.downloadBatch(response, query);
    }

    /**
     * 批量导入excel
     *
     * @return result
     */
    @ApiOperation("批量导入excel")
    @PostMapping(value = "/potentialCustomer/batchImport", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImport(HttpServletResponse response, MultipartFile file,Boolean force) {
        Map<String, Object> resultMap = service.importBatch(response, file, force);
        if(resultMap.get("ok").equals("ok")){
            return TwOutputUtil.ok();
        }else if(resultMap.get("ok").equals("warn")){
            return TwOutputUtil.warn("","",resultMap);
        }else{
            return TwOutputUtil.error("","",resultMap);
        }
    }

    @ApiOperation("批量导入excel")
    @PostMapping(value = "/potentialCustomer/batchImportPro", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public TwOutputUtil batchImportPro(MultipartFile file, Boolean force) throws InterruptedException {
        Map<String, Object> resultMap = service.importBatchPro(file, force);
        if (resultMap.get("ok").equals("ok")) {
            return TwOutputUtil.ok();
        } else if (resultMap.get("ok").equals("warn")) {
            return TwOutputUtil.warn("", "", resultMap);
        } else {
            return TwOutputUtil.error("", "", resultMap);
        }
    }


    /**
     * 批量添加标签
     * @param keys 批量修改的列表
     * @param tagIds 要添加的标签列表
     * @return result
     */
    @GetMapping("/potentialCustomer/batchAddTags")
    public TwOutputUtil batchAddTags(Long[] keys,String tagIds) {
        service.batchAddTags(keys, tagIds);
        return TwOutputUtil.ok();
    }

    /**
     * 批量删除标签
     * @param keys 批量修改的列表
     * @param tagIds 要添加的标签列表
     * @return result
     */
    @GetMapping("/potentialCustomer/batchDelTags")
    public TwOutputUtil batchDelTags(Long[] keys,String tagIds) {
        service.batchDelTags(keys, tagIds);
        return TwOutputUtil.ok();
    }


    /**
     * 重复性校验
     * @param type 校验类型（企业名称、联系人电话）
     * @param checkValue 待校验的值
     * @return result
     */
    @GetMapping("/potentialCustomer/checkRepeat")
    public TwOutputUtil checkRepeat(String type,String checkValue) {
        List<Map<String,Object>> repeatMessage = crmCommonService.checkRepeat(type,checkValue);
        if(repeatMessage==null || repeatMessage.isEmpty()){
            return TwOutputUtil.ok();
        }else{
            return TwOutputUtil.ok("","",repeatMessage);
        }
    }


}
