package com.elitesland.tw.tw5.server.prd.crm.dao;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityOutCostPayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityOutCostVO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityOutCostDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityOutCostDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityOutCostRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author carl.wang
 * @Description:
 * @date
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityOutCostDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityOutCostRepo repo;
    private final QCrmOpportunityOutCostDO qdo = QCrmOpportunityOutCostDO.crmOpportunityOutCostDO;

    /**
     * @param id
     * @return
     * @Description
     **/
    public Long queryTW4IdById(Long id) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.outCostIdV4).from(qdo);
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    public CrmOpportunityOutCostVO queryById(Long key) {
        JPAQuery<CrmOpportunityOutCostVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(key));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * @param ids
     * @return
     * @Description
     **/
    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.outCostIdV4).from(qdo);
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpportunityOutCostDO save(CrmOpportunityOutCostDO ado) {
        return repo.save(ado);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityOutCostVO> getJpaQuerySelect() {
        JPAQuery<CrmOpportunityOutCostVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmOpportunityOutCostVO.class,
                qdo.id,
                qdo.oppoId,
                qdo.sortNo,
                qdo.activataStatus,
                qdo.approvalStatus,
                qdo.applyUserId,
                qdo.costDesc,
                qdo.creator,
                qdo.createUserId,
                qdo.createTime,
                qdo.applyDate,
                qdo.remark
        )).from(qdo);
        return jpaQuery;
    }

    /**
     * @param oppoId 商家主键
     * @return
     * @Description 主键查询
     **/
    public List<CrmOpportunityOutCostVO> queryList(Long oppoId) {
        JPAQuery<CrmOpportunityOutCostVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.oppoId.eq(oppoId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        return update.execute();
    }


    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象活动
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CrmOpportunityOutCostPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .where(qdo.id.eq(payload.getId()));
        if (payload.getProcInstStatus() != null) {
            update.set(qdo.procInstStatus, payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(qdo.submitTime, payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(qdo.approvedTime, payload.getApprovedTime());
        }
        if (payload.getApprovalStatus() != null) {
            update.set(qdo.approvalStatus, payload.getApprovalStatus());
        }
        if (payload.getActivataStatus() != null) {
            update.set(qdo.activataStatus, payload.getActivataStatus());
        }
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        if (payload.getOutCostIdV4() != null) {
            update.set(qdo.outCostIdV4, payload.getOutCostIdV4());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            if (nullFields.contains("procInstStatus")) {
                update.setNull(qdo.procInstStatus);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
        }
        // 执行修改
        return update.execute();
    }

}
