package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Author carl.wang
 * @Description 市场计划明细表
 * @Date
 **/
@Entity
@Table(name = "crm_act_plan_detail", indexes = {@Index(name = "plan_index", columnList = "plan_id")})
@org.hibernate.annotations.Table(appliesTo = "crm_act_plan_detail", comment = "市场计划明细表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmActPlanDetailDO extends BaseModel {

    @Comment("计划id")
    @Column(name = "plan_id")
    private Long planId;

    @Comment("季节")
    @Column()
    private String detailSeason;

    @Comment("类型")
    @Column()
    private String detailType;

    @Comment("名称")
    @Column()
    private String detailName;

    @Comment("人力费用")
    @Column()
    private BigDecimal personMoney;

    @Comment("人力资源")
    @Column()
    private String personSource;

    @Comment("报销费用")
    @Column()
    private BigDecimal claimMoney;

    @Comment("采购费用")
    @Column()
    private BigDecimal purchaseMoney;

    @Comment("杂项费用")
    @Column()
    private BigDecimal sundryMoney;

    @Comment("合计")
    @Column()
    private BigDecimal totalMoney;

    @Comment("支出额")
    @Column()
    private BigDecimal expenditure;

    @Comment("产出总线索")
    @Column()
    private Integer leadNum;

    @Comment("产出预估总数")
    @Column()
    private BigDecimal pipeline;


    private BigDecimal extDecimal1;
    private BigDecimal extDecimal2;

    private String extString1;
    private String extString2;
    private String extString3;

    //   private String extDecimal3;
//    private String extString4;
//    private String extString5;

}
