package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
* 客户经营-企业年报网址
*
* @author duwh
* @date 2022-12-05
*/
@Entity
@Table(name = "crm_customer_operation_sites", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_customer_operation_sites", comment = "客户经营-企业年报网址")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmCustomerOperationSitesDO extends BaseModel  {
    /** 客户经营主键 */
    @Comment("客户经营主键")
    @Column()
    private Long operId;
    /** 审核时间 */
    @Comment("审核时间")
    @Column()
    private String date;
    /** 网址 */
    @Comment("网址")
    @Column()
    private String url;
    /** 企业网址名称 */
    @Comment("企业网址名称")
    @Column()
    private String name;
    /** 网址类型 */
    @Comment("网址类型")
    @Column()
    private String type;

    public void copy(CrmCustomerOperationSitesDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
