package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.util.List;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/26 - 21:57
 */
@Entity
@Table(name = "crm_offshore_rule_regain")
@org.hibernate.annotations.Table(appliesTo = "crm_offshore_rule_regain", comment = "近海线索收回规则表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOffshoreRuleRegainDO extends BaseModel {

    /**
     * 0：其他近海，1：本近海
     */
    @Comment("回收到本近海")
    @Column(name = "to_this_offshore")
    private Integer toThisOffshore;

    @Comment("目标近海")
    private Long targetOffshore;

    @Comment("超时未跟进提醒时间")
    @Column(name = "regain_remind_time")
    private Long regainRemindTime;


    @Comment("触发方式")
    @OrderColumn
    @OneToMany(fetch = FetchType.LAZY,cascade = CascadeType.ALL)
    @JoinColumn(name="regainId", foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    private List<CrmOffshoreRuleRegainTriggerDO> triggerRules;



}
