package com.elitesland.tw.tw5.server.prd.crm.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.payload.PrdSystemBusinessChangePayload;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActDynamicPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActReportPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPotentialCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.vo.*;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.change.dao.PrdSystemBusinessChangeDAO;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActActivityConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActDynamicConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmActReportConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActPlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActDynamicDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmActReportDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmActPlanDetailRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectMemberDO;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.querydsl.core.QueryResults;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author carl.wang
 * @Description 市场活动管理
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmActActivityServiceImpl extends BaseServiceImpl implements CrmActActivityService {
    private final CacheUtil cacheUtil;
    private final PrjProjectDAO projectDAO;
    private final CrmActActivityDAO dao;
    private final PrdSystemRoleDAO daoRole;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final CrmActPlanDAO daoPlan;
    //private final CrmLeadsServiceImpl service;
    //private final CrmPotentialCustomerService customerService;
    private final FileUtil fileUtil;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final TransactionTemplate transactionTemplate;
    private final PrdOrgOrganizationDAO daoOrg;
    private final TransactionUtilService transactionUtilService;
    private final PrdSystemBusinessChangeService changeService;
    private final PrdSystemBusinessChangeDAO changeDAO;
    private final PrdMessageConfigService messageConfigService;
    private final PrdMessageConfigRepo repoMessage;
    private final WorkflowUtil workflowUtil;
    private final CrmActPlanDetailRepo actPlanDetailRepo;
    //    private final PrdOrgOrganizationDAO daoOrg;
//    private final PrdSystemSelectionService selectionService;
    @Value("${tw5.user_default.user_id}")
    private Long default_user_id;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;
    // @DubboReference(version = "${provider.service.version}")
//    @Autowired
    //private SysNumberRuleService numberRuleService;

    /**
     * 定时任务处理逾期邮件
     */
    @Transactional
    @Override
    public void activityUnReleaseJobHandler() {
        List<CrmActActivityVO> activitys = dao.findActivityUnReleases();
        if (!ObjectUtils.isEmpty(activitys)) {
            List<Long> activityIds = activitys.stream().map(CrmActActivityVO::getId).collect(Collectors.toList());
            PrdSystemRoleVO roleVO = daoRole.queryByCode("MARKET-MANAGE");
            List<PrdMessageConfigDO> messageConfigDOS = new ArrayList<>();
            activitys.forEach(activity -> {
                String code = generateSeqNum("MESSAGE_CONFIG_NO");
                String content = "活动 {" + activity.getProjectNo() + "--" + activity.getProjectName() + "}，审批结束已超3个自然日，{" +
                        cacheUtil.getUserName(activity.getCreateUserId()) + "} 暂未发布公告/邮件，请及时处理。";
                PrdMessageConfigDO ado = new PrdMessageConfigDO();
                ado.setMessageCode(code);
                ado.setMessageTitle("“活动待发布”逾期通知");
                ado.setMessageContent(content);
                ado.setCreateUserId(default_user_id);
                ado.setContentBigType("companyMessage");
                ado.setContentType("systemMessage");
                ado.setCreateSource("系统管理员");
                ado.setIsEnable(0);
                ado.setMessageType(2);
                ado.setNoticeScope("appoint_role");
                ado.setNoticeSource(roleVO.getId() + "");
                ado.setNoticeWay("email");
                ado.setTenantId(activity.getTenantId());
                ado.setReleaseSource("profileMessage");
                ado.setReleaseStatus(3);
                ado.setTriggerTime(LocalDateTime.now());
                messageConfigDOS.add(ado);
            });
            //保存邮件信息
            List<PrdMessageConfigDO> messageConfigDOS1 = repoMessage.saveAll(messageConfigDOS);
            //发送邮件
            List<PrdMessageConfigVO> messageConfigVOS = messageConfigDOS1.stream().map(PrdMessageConfigConvert.INSTANCE::toVo).collect(Collectors.toList());
            messageConfigService.releaseMessage(messageConfigVOS);
            //修改活动逾期状态
            dao.updateEmailRemind(activityIds);
        }
    }

    @Override
    public PagingVO<CrmActActivityVO> queryPagingUnReleased(CrmActActivityQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        query.setIsRelease(0);
        query.setCreateUserId(userId);
        PagingVO<CrmActActivityVO> activityVOPagingVO = dao.queryPagingUnReleased(query);
        List<CrmActActivityVO> activityVOS = activityVOPagingVO.getRecords();
        activityVOS.forEach(activityVO -> transferSystemSelection(activityVO));
        return activityVOPagingVO;
    }

    @Override
    public Map<String, Object> findActivityUnReleaseByUserId(long userId) {
        QueryResults<CrmActActivityDO> activityRelease = dao.findActivityReleaseByUserId(userId);
        long total = activityRelease.getTotal();

        Map<String, Object> map = new HashMap<>();
        map.put("num", total);
        if (total > 0) {
            CrmActActivityDO crmActActivityDO = activityRelease.getResults().get(0);
            long actSecond = crmActActivityDO.getApprovedTime().toEpochSecond(ZoneOffset.of("+8")) + 3 * 24 * 60 * 60 - LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
            map.put("time", actSecond);
        }
        return map;
    }

    /**
     * 仅支持不发布公告的接口
     *
     * @param id
     */
    @Transactional
    @Override
    public void refuseRelease(Long id) {
        dao.updataReleaseByIds(List.of(id), 1);
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public CrmActActivityVO insert(CrmActActivityPayload payload) {
        CrmActPlanVO planVO = daoPlan.queryBykey(payload.getPlanId());
        if (!planVO.getPlanStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "该计划暂未激活");
        }
        //获取计划明细所有花费额
        List<CrmActActivityDO> actActivityDOS = dao.queryActivityByDetailId(payload.getDetailId());
        BigDecimal totalMoney = new BigDecimal("0");
        for (CrmActActivityDO actActivityDO : actActivityDOS) {
            totalMoney = totalMoney.add(actActivityDO.getTotalMoney());
        }
        totalMoney = totalMoney.add(payload.getTotalMoney());
        Optional<CrmActPlanDetailDO> planDetailOptional = actPlanDetailRepo.findById(payload.getDetailId());
        if (planDetailOptional.isEmpty()) {
            log.error("根据id{}未查到计划明细", payload.getDetailId());
            throw new BusinessException("未查到该活动对应的计划明细");
        }
        CrmActPlanDetailDO planDetailDO = planDetailOptional.get();
        planDetailDO.setExpenditure(totalMoney);
        actPlanDetailRepo.save(planDetailDO);

        //获取编号
        String code = generateSeqNum("ACT_PROJECT_NO");
        //编程式事务 --> 保存业务数据（将结果保存到数据库）
        //设置事务传播行为
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        CrmActActivityVO execute = transactionTemplate.execute(transactionStatus -> {
            //保存项目
            PrjProjectDO ado = CrmActActivityConvert.INSTANCE.toProjectDo(payload);
            ado.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
            ado.setProjectType(CrmFollowObjectEnum.Activity.getCode());
            ado.setProjectNo(code);
            ado = projectDAO.save(ado);
            //保存活动
            CrmActActivityDO crmActActivityDO = CrmActActivityConvert.INSTANCE.toDo(payload);
            crmActActivityDO.setProjectId(ado.getId());
            dao.save(crmActActivityDO);
            CrmActActivityVO crmActActivityVO = CrmActActivityConvert.INSTANCE.toVo(crmActActivityDO);
            crmActActivityVO.setOrgId(ado.getOrgId());
            if (payload.getSubmit() != null && payload.getSubmit()) {
                submitProc(crmActActivityVO);
                //发邮件
                sendEmail(ado.getProjectName(), crmActActivityDO.getTotalMoney(), planVO, planDetailDO);
            }
            //把创建人和负责人添加为团队成员
            List<Long> userIds = new ArrayList<>();
            userIds.add(ado.getCreateUserId());
            userIds.add(ado.getManageUserId());
            addProjectMember(ado.getId(), userIds);
            return crmActActivityVO;
        });
        return execute;
    }

    /**
     * 邮件模版
     * <p>活动名称：#{actName}</p>
     * <p>本次活动预算总额：#{actTotalMoney}</p>
     * <p>市场计划：#{planName}</p>
     * <p>季度预算总额：#{budgetTotalMoney}</p>
     * <p>季度预算余额：#{budgetBalanceMoney}</p>
     * <p></p>
     * <p>因新增“#{actName}”活动，当前#{buName}（BU）的市场计划预算已超支，烦请相关BU重新制定合理的市场计划预算，发起预算变更申请！</p>
     */
    private void sendEmail(String projectName, BigDecimal actTotalMoney, CrmActPlanVO planVO, CrmActPlanDetailDO planDetailDO) {
        //捕获异常，邮件发送是否成功不应影响事务
        try {
            BigDecimal balanceMoney = planDetailDO.getTotalMoney().subtract(planDetailDO.getExpenditure());
            log.info("季度预算余额:{}", balanceMoney);
            if (balanceMoney.signum() != -1) {
                return;
            }

            log.info("开始发邮件逻辑");
            List<Long> receiveUserIds = new ArrayList<>();
            PrdOrgOrganizationVO organizationVO = orgOrganizationDAO.queryOrgById(planVO.getOrgId());
            if (organizationVO != null && organizationVO.getManageId() != null) {
                receiveUserIds.add(organizationVO.getManageId());
            }
            PrdOrgOrganizationDO orgOrganizationDO = orgOrganizationDAO.queryByName("市场部");
            receiveUserIds.add(orgOrganizationDO.getManageId());

            String noticeSource = String.join(",", receiveUserIds.stream().map(String::valueOf).collect(Collectors.toList()));
            Map<String, Object> data = new HashMap<>();
            data.put("actName", projectName);
            data.put("actTotalMoney", actTotalMoney);
            data.put("planName", planVO.getPlanName());
            data.put("budgetTotalMoney", planDetailDO.getTotalMoney());
            data.put("budgetBalanceMoney", planDetailDO.getTotalMoney().subtract(planDetailDO.getExpenditure()));
            data.put("buName", planVO.getOrgName());

            PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20230208181400");
            messageConfigService.sendMessageConfig(configVO, data, "appoint_people", noticeSource);
            log.info("邮件发送成功");
        } catch (Exception e) {
            log.info("邮件发送出现异常");
            log.error(e.getMessage(), e);
        }
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public boolean changeManger(Long key, Long userId, Integer opeStatus) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        checkUpdate(project);
        Long nUserId = GlobalUtil.getLoginUserId();
        if (project.getCreateUserId() == null || project.getCreateUserId().longValue() != nUserId.longValue()) {
            throw TwException.error("", "无该数据操作权限");
        }

        if (project.getManageUserId().longValue() != userId.longValue()) {
            deleteProjectMember(project.getId(), Arrays.asList(project.getManageUserId()));
            addProjectMember(project.getId(), Arrays.asList(userId));
//            if (opeStatus == 1) {
//                PrjProjectMemberDO memberDO = new PrjProjectMemberDO();
//                memberDO.setProjectId(project.getId());
//                memberDO.setUserId(project.getManageUserId());
//                memberDO.setEmployeeName(project.getManageUserName());
//                projectDAO.saveMember(memberDO);
//            }
            projectDAO.updateProjectManger(project.getId(), userId);
        }
        return true;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public Long update(CrmActActivityPayload payload) {
        CrmActProjectVO project = dao.queryProjectBykey(payload.getId());
        CrmActActivityVO crmActActivityVO = dao.queryBykey(payload.getId());

        //如果单据状态为新增状态
        if (payload.getProjectStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode()) || (payload.getDoSave() != null && payload.getDoSave() == true)) {
            if (payload.getDoSave() == null || payload.getDoSave() == false) {
                checkUpdate(project);
            }
            //返回当前活动对应的计划明细
            CrmActPlanDetailDO curPlanDetailDO = updatePlan(project, payload);
            dao.updateActivityByKeyDynamic(payload);
            // payload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
            dao.updateProjectByKeyDynamic(payload, project.getId());
            if (payload.getSubmit() != null && payload.getSubmit()) {
                submitProc(crmActActivityVO);
                CrmActPlanVO planVO = daoPlan.queryBykey(payload.getPlanId());
                sendEmail(payload.getProjectName(), payload.getTotalMoney(), planVO, curPlanDetailDO);
            }
        } else {
            checkUpdate(project);
            // 发起流程
            //保存log版本，payload存本次更新的数据
            changeService.saveVersionLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), payload, null, null);
            //发起变更流程
            if (payload.getSubmit() != null && payload.getSubmit()) {
                submitChangeProc(crmActActivityVO);
                CrmActPlanVO planVO = daoPlan.queryBykey(payload.getPlanId());
                //返回当前活动对应的计划明细
                CrmActPlanDetailDO curPlanDetailDO = getCurPlanDetailDO(project, payload);
                sendEmail(payload.getProjectName(), payload.getTotalMoney(), planVO, curPlanDetailDO);
            }
        }
        //团队成员变更操作
        if (project.getManageUserId().longValue() != payload.getManageUserId().longValue()) {
            deleteProjectMember(project.getId(), Arrays.asList(project.getManageUserId()));
            addProjectMember(project.getId(), Arrays.asList(payload.getManageUserId()));
        }
//        if (payload.getOpeStatus().equals("submit")) {
//            //TODO 工作流处理
//            //ado.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
//            String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
//            updateWorkFlowStatus(project.getId(), status, "");
//        }
        return 0L;
    }


    public CrmActPlanDetailDO updatePlan(CrmActProjectVO project, CrmActActivityPayload payload) {
        Optional<CrmActPlanDetailDO> planDetailOptional = actPlanDetailRepo.findById(payload.getDetailId());
        if (planDetailOptional.isEmpty()) {
            log.error("根据id{}未查到计划明细", payload.getDetailId());
            throw new BusinessException("未查到该活动对应的计划明细");
        }
        CrmActPlanDetailDO planDetailDO = planDetailOptional.get();
        if (project.getDetailId().longValue() == payload.getDetailId().longValue()) {
            if (payload.getTotalMoney().compareTo(project.getTotalMoney()) != 0) {
                //获取计划明细所有花费额
                List<CrmActActivityDO> actActivityDOS = dao.queryActivityByDetailId(payload.getDetailId());
                BigDecimal totalMoney = new BigDecimal("0");

                for (CrmActActivityDO activityDO : actActivityDOS) {
                    if (activityDO.getId().longValue() != payload.getId().longValue()) {
                        totalMoney = totalMoney.add(activityDO.getTotalMoney());
                    }
                }
                totalMoney = totalMoney.add(payload.getTotalMoney());
                planDetailDO.setExpenditure(totalMoney);
                actPlanDetailRepo.save(planDetailDO);
            }
        } else {
            //为新变更的明细加值
            List<CrmActActivityDO> actActivityDOS = dao.queryActivityByDetailId(payload.getDetailId());
            BigDecimal totalMoney = new BigDecimal("0");

            for (CrmActActivityDO activityDO : actActivityDOS) {
                totalMoney = totalMoney.add(activityDO.getTotalMoney());
            }
            totalMoney = totalMoney.add(payload.getTotalMoney());
            planDetailDO.setExpenditure(totalMoney);
            actPlanDetailRepo.save(planDetailDO);
            //为老的明细去除值
            List<CrmActActivityDO> OldActActivityDOS = dao.queryActivityByDetailId(project.getDetailId());
            BigDecimal oldTotalMoney = new BigDecimal("0");
            for (CrmActActivityDO activityDO : OldActActivityDOS) {

                if (activityDO.getId().longValue() != payload.getId().longValue()) {
                    oldTotalMoney = oldTotalMoney.add(activityDO.getTotalMoney());
                }
            }
            dao.updatePlanDetail(project.getDetailId(), oldTotalMoney);
        }
        return planDetailDO;
    }

    /**
     * 查询并计算最新的CrmActPlanDetailDO 但不做修改
     *
     * @param project
     * @param payload
     * @return
     */
    public CrmActPlanDetailDO getCurPlanDetailDO(CrmActProjectVO project, CrmActActivityPayload payload) {
        Optional<CrmActPlanDetailDO> planDetailOptional = actPlanDetailRepo.findById(payload.getDetailId());
        if (planDetailOptional.isEmpty()) {
            log.error("根据id{}未查到计划明细", payload.getDetailId());
            throw new BusinessException("未查到该活动对应的计划明细");
        }
        CrmActPlanDetailDO planDetailDO = planDetailOptional.get();

        if (project.getDetailId().longValue() == payload.getDetailId().longValue()) {
            if (payload.getTotalMoney().compareTo(project.getTotalMoney()) != 0) {
                //获取计划明细所有花费额
                List<CrmActActivityDO> actActivityDOS = dao.queryActivityByDetailId(payload.getDetailId());
                BigDecimal totalMoney = new BigDecimal("0");

                for (CrmActActivityDO activityDO : actActivityDOS) {
                    if (activityDO.getId().longValue() != payload.getId().longValue()) {
                        totalMoney = totalMoney.add(activityDO.getTotalMoney());
                    }
                }
                totalMoney = totalMoney.add(payload.getTotalMoney());
                planDetailDO.setExpenditure(totalMoney);
            }
        } else {
            //为新变更的明细加值
            List<CrmActActivityDO> actActivityDOS = dao.queryActivityByDetailId(payload.getDetailId());
            BigDecimal totalMoney = new BigDecimal("0");

            for (CrmActActivityDO activityDO : actActivityDOS) {
                totalMoney = totalMoney.add(activityDO.getTotalMoney());
            }
            totalMoney = totalMoney.add(payload.getTotalMoney());
            planDetailDO.setExpenditure(totalMoney);
        }
        return planDetailDO;
    }

    @Override
    public boolean deleteSoft(List<Long> keys) {
        return false;
    }

    @Override
    public PagingVO<CrmActActivityVO> paging(CrmActActivityQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> orgManageIds = orgOrganizationDAO.queryByManageIdOrgIds(userId);
        // 部门下的成员包括当前登录人本人
        List<Long> actUserIds = new ArrayList<>();
        // 判断当前登录人是否是系统管理员or市场管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            actUserIds = null;
        } else {
            PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(userId);
            if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                Long orgId = prdOrgEmployeeRefVO.getOrgId();
                //查询部门下的成员
                List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = orgOrganizationDAO.queryEmployeeList(orgId);
                actUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
            } else {
                actUserIds = Collections.singletonList(userId);
            }
        }

        PagingVO<CrmActActivityVO> activityVOPagingVO = dao.queryPaging(query, actUserIds, orgManageIds);
        List<CrmActActivityVO> activityVOS = activityVOPagingVO.getRecords();
        activityVOS.forEach(activityVO -> transferSystemSelection(activityVO));
        return activityVOPagingVO;
    }

    @Override
    public void downloadActivitys(HttpServletResponse response, CrmActActivityQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmActivityBatch.xlsx");
        PagingVO<CrmActActivityVO> evo = paging(query);
        List<CrmActActivityVO> list = evo.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("市场活动");

            //  excelUtil.generateRangeList(batchProjectSheet, 2, 2, "活动类型", 2, "A"); // 最终客户 数据验证

            if (!CollectionUtils.isEmpty(list) && batchProjectSheet != null) {
                int nextRow = 2;
                for (CrmActActivityVO dataPayload : list) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    excelUtil.setCellValue(row, 1, dataPayload.getProjectNo());// 季度
                    excelUtil.setCellValue(row, 2, dataPayload.getProjectName());// 活动类型
                    excelUtil.setCellValue(row, 3, dataPayload.getPlanName());// 项目
                    excelUtil.setCellValue(row, 4, dataPayload.getDetailTypeName());// 人力费用
                    excelUtil.setCellValue(row, 5, dataPayload.getProjectStatusName());// 人力资源
                    excelUtil.setCellValue(row, 6, dataPayload.getManageUserName());//差旅费用
                    excelUtil.setCellValue(row, 7, dataPayload.getOrgName());// 采购费用
                    excelUtil.setCellValue(row, 8, dataPayload.getStartTime());//杂项费用
                    excelUtil.setCellValue(row, 9, dataPayload.getEndTime());//费用合计
                    excelUtil.setCellValue(row, 10, dataPayload.getPlanDetailTotalMoney());// 线索
                    excelUtil.setCellValue(row, 11, dataPayload.getBalanceMoney());//

                    excelUtil.setCellValue(row, 12, dataPayload.getTotalMoney());// 季度
                    excelUtil.setCellValue(row, 13, dataPayload.getActivityScale());// 活动类型
                    excelUtil.setCellValue(row, 14, dataPayload.getActivityAddr());// 项目
                    excelUtil.setCellValue(row, 15, dataPayload.getActivityTarget());// 人力费用

                    excelUtil.setCellValue(row, 16, dataPayload.getCreator());// 人力资源
                    excelUtil.setCellValue(row, 17, dataPayload.getCreateTime());//差旅费用

                    excelUtil.setCellValue(row, 18, dataPayload.getPurchaseMoney());//杂项费用
                    excelUtil.setCellValue(row, 19, dataPayload.getClaimMoney());//费用合计
                    excelUtil.setCellValue(row, 20, dataPayload.getSundryMoney());// 线索
                    excelUtil.setCellValue(row, 21, dataPayload.getBudgetMoney());//
                    excelUtil.setCellValue(row, 22, dataPayload.getPersonSource());//费用合计
                    excelUtil.setCellValue(row, 23, dataPayload.getPersonNum());// 线索
                    excelUtil.setCellValue(row, 24, dataPayload.getPersonMoney());//

                    excelUtil.setCellValue(row, 25, dataPayload.getPotentialCustomer());//
                    excelUtil.setCellValue(row, 26, dataPayload.getLeadNum());//费用合计
                    excelUtil.setCellValue(row, 27, dataPayload.getBusOps());// 线索
                    excelUtil.setCellValue(row, 28, dataPayload.getPipeline());//

                    nextRow++;
                }
            }

            String fileName = "市场活动数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<CrmActProjectVO> queryList(Long planId) {

        return dao.queryList(planId);
    }

    @Override
    public CrmActActivityVO queryByKey(Long key) {
        CrmActActivityVO activityVO = dao.queryBykey(key);
        transferSystemSelection(activityVO);
        activityVO.setBalanceMoney(activityVO.getPlanDetailTotalMoney().subtract(activityVO.getExpenditure()));
        activityVO.setMemberVOS(dao.queryProjectMember(activityVO.getProjectId()));
        List<CrmActDynamicVO> dynamicVOS = dao.queryActDynamic(activityVO.getId());
        dynamicVOS.forEach(dynamicVO -> {
            dynamicVO.setDynamicTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType()));
            dynamicVO.setFileDatas(fileUtil.getFileDatas(dynamicVO.getFileCodes()));
        });
        activityVO.setDynamicVOS(dynamicVOS);
        activityVO.setFileDatas(fileUtil.getFileDatas(activityVO.getFileCodes()));
        return activityVO;
    }

    @Override
    public List<CrmActDynamicVO> queryDynamicByKey(Long key) {
        List<CrmActDynamicVO> dynamicVOS = dao.queryActDynamic(key);
        dynamicVOS.forEach(dynamicVO -> {
            dynamicVO.setDynamicTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType()));
            dynamicVO.setFileDatas(fileUtil.getFileDatas(dynamicVO.getFileCodes()));
        });
        return dynamicVOS;
    }

    @Override
    public List<PrjProjectMemberVO> queryMembersByKey(Long key) {
        CrmActActivityVO activityVO = dao.queryBykey(key);
        List<PrjProjectMemberVO> prjProjectMemberVOS = dao.queryProjectMember(activityVO.getProjectId());
        return prjProjectMemberVOS;
    }


    @Override
    public List<CrmActReportVO> queryReportByKey(Long key, Integer reportType) {
        //根据report的id获取其活动id
        Long activityId = dao.queryByReportId(key);
        return queryActReportList(activityId, reportType);
    }

    @Transactional
    @Override
    public boolean changeLockStatus(Long key) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        String status = "";
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            status = WorkFlowStatusEnum.PENDING_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        } else {
            throw TwException.error("", "活动状态为激活/暂挂才可进行该操作");
        }
        dao.updateStatus(project.getId(), status, "");
        return true;
    }

    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public List<PrjProjectMemberVO> addMember(Long key, List<Long> userIds) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "非激活状态不可进行该操作");
        }
        List<Long> nuserIds = new ArrayList<>();
        if (project.getCreateUserId() != null) {
            nuserIds.add(project.getCreateUserId());
        }
        if (project.getManageUserId() != null) {
            nuserIds.add(project.getManageUserId());
        }
        //系统管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
        nuserIds.addAll(userIdsByRole);
        Long userId = GlobalUtil.getLoginUserId();
        if (project.getCreateUserId() == null || !nuserIds.contains(userId)) {
            throw TwException.error("", "无添加团队成员权限");
        }
        addProjectMember(project.getId(), userIds);
//        List<PrjProjectMemberDO> prjProjectMemberDOS = projectDAO.saveMemberAll(memberDOS);
//        for (PrjProjectMemberDO prjProjectMemberDO : prjProjectMemberDOS) {
//            memberVOS.add(PrjProjectMemberConvert.INSTANCE.toVo(prjProjectMemberDO));
//        }
        return dao.queryProjectMember(project.getId());

    }

    /**
     * 执行数据库添加团队成员操作
     *
     * @param projectId
     * @param userIds
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public void addProjectMember(Long projectId, List<Long> userIds) {
        List<PrjProjectMemberVO> memberVOS = dao.queryProjectMember(projectId);
        List<Long> collect = userIds.stream().filter(userId -> memberVOS.stream().noneMatch(memberVO -> memberVO.getUserId().longValue() == userId.longValue())).collect(Collectors.toList());
        List<PrdOrgEmployeeVO> employeeVOS = dao.queryEmployee(collect);
        List<PrjProjectMemberDO> memberDOS = new ArrayList<>();
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            PrjProjectMemberDO memberDO = new PrjProjectMemberDO();
            memberDO.setProjectId(projectId);
            memberDO.setUserId(employeeVO.getUserId());
            memberDO.setEmployeeName(employeeVO.getEmployeeName());
            memberDOS.add(memberDO);
        }
        projectDAO.saveMemberAll(memberDOS);
    }

    /**
     * 执行数据库删除团队成员操作
     *
     * @param projectId
     * @param userIds
     */
    @Transactional(propagation = Propagation.REQUIRED)
    public void deleteProjectMember(Long projectId, List<Long> userIds) {
        projectDAO.deleteMemberByUserId(projectId, userIds);
    }


    @Transactional(propagation = Propagation.REQUIRED)
    @Override
    public boolean deleteMember(Long actId, List<Long> keys) {
        CrmActProjectVO project = dao.queryProjectBykey(actId);

        List<Long> userIds = new ArrayList<>();
        if (project.getCreateUserId() != null) {
            userIds.add(project.getCreateUserId());
        }
        if (project.getManageUserId() != null) {
            userIds.add(project.getManageUserId());
        }
        Long userId = GlobalUtil.getLoginUserId();
        if (project.getCreateUserId() == null || !userIds.contains(userId)) {
            throw TwException.error("", "无删除团队成员权限");
        }
        List<Long> userMemberIds = projectDAO.getUserIds(keys);
        if (userIds.size() > 0 && userIds.contains(userMemberIds.get(0))) {
            throw TwException.error("", "创建人或负责人不可删除");
        }
        projectDAO.deleteMemberSoft(keys, userIds);
        return true;
    }

    @Transactional
    @Override
    public List<CrmActDynamicVO> addDynamic(CrmActDynamicPayload payload) {
        CrmActProjectVO project = dao.queryProjectBykey(payload.getActId());
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "非激活状态不可进行该操作");
        }
        List<CrmActDynamicVO> dynamicVOS = dao.queryActDynamic(payload.getActId());
        CrmActDynamicDO dynamicDO = CrmActDynamicConvert.INSTANCE.toDo(payload);
        dynamicDO = dao.saveDynamic(dynamicDO);
        dynamicVOS.add(CrmActDynamicConvert.INSTANCE.toVo(dynamicDO));
        dynamicVOS.forEach(dynamicVO -> dynamicVO.setDynamicTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType())));

        return dynamicVOS;
    }

    @Transactional
    @Override
    public boolean updateDynamic(CrmActDynamicPayload payload) {
        CrmActProjectVO project = dao.queryProjectBykey(payload.getActId());
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "非激活状态不可进行该操作");
        }
        dao.updateDynamic(payload);
        return true;
    }

    @Override
    public CrmActDynamicVO queryActDynamicDetail(Long key) {
        CrmActDynamicVO dynamicVO = dao.queryActDynamicDetail(key);
        dynamicVO.setDynamicTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmActDynamicType.getCode(), dynamicVO.getDynamicType()));
        dynamicVO.setFileDatas(fileUtil.getFileDatas(dynamicVO.getFileCodes()));
        return dynamicVO;
    }

    @Transactional
    @Override
    public boolean closeActivity(Long key, String closeReson, String clsoeRemark) {
        CrmActProjectVO project = dao.queryProjectBykey(key);
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "非激活状态不可进行该操作");
        }
        if (closeReson.equals("act_end")) {
            throw TwException.error("", "请先发起活动结项报告");
        }
        CrmActActivityPayload payload = new CrmActActivityPayload();
        payload.setProjectStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
        payload.setCloseReason(closeReson);
        payload.setClsoeRemark(clsoeRemark);
        dao.updateProjectByKeyDynamic(payload, project.getId());
        return true;
    }

    @Override
    public CrmActReportVO queryActReportData(Long key) {
        CrmLeadsServiceImpl service = SpringUtil.getBean(CrmLeadsServiceImpl.class);
        CrmPotentialCustomerService customerService = SpringUtil.getBean(CrmPotentialCustomerService.class);
        CrmActReportVO reportVO = dao.queryActReportData(key);
        Integer marketLeadsNum = service.countMarketLeads(reportVO.getProjectId());
        reportVO.setProjectStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), reportVO.getProjectStatus()));
        reportVO.setLeadNum(marketLeadsNum);
        reportVO.setBusOps((int) dao.queryOppoCount(reportVO.getProjectId()));
        reportVO.setLeadsFollowPercent(service.countMarketLeadsFollowPercent(marketLeadsNum, reportVO.getProjectId()));
        reportVO.setLeadsBackPercent(service.countMarketLeadsBackPercent(reportVO.getProjectId()));
        reportVO.setPotentialCustomer((int) customerService.countByActivityId(reportVO.getProjectId()));
        //TODO 数据还没给
        return reportVO;
    }

    @Transactional
    @Override
    public CrmActReportVO addReport(CrmActReportPayload payload) {
        //获取编号
        String code = generateSeqNum("ACT_REPORT_NO");
        CrmActProjectVO project = dao.queryProjectBykey(payload.getActId());
        if (!project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            throw TwException.error("", "非激活状态不可进行该操作");
        }
        CrmActReportDO reportDO = CrmActReportConvert.INSTANCE.toDo(payload);
        reportDO.setReportNo(code);
        if (reportDO.getReportType() == 2) {
            //发起结项报告审批流程
            //编程式事务 --> 保存业务数据（将结果保存到数据库）
            transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
            CrmActReportDO finalReportDO = reportDO;
            transactionTemplate.execute(transactionStatus -> {
                dao.saveReport(finalReportDO);
                return null;
            });
            CrmActReportVO crmActReportVO = CrmActReportConvert.INSTANCE.toVo(reportDO);
//            if(payload.getSubmit()!=null && payload.getSubmit()){
            submitReportProc(crmActReportVO);
//            }
        } else {
            reportDO = dao.saveReport(reportDO);
        }
        return CrmActReportConvert.INSTANCE.toVo(reportDO);
    }


    @Override
    public List<CrmActReportVO> queryActReportList(Long actId, Integer reportType) {
        List<CrmActReportVO> reportVOS = dao.queryActReportList(actId, reportType);
        reportVOS.forEach(reportVO -> reportVO.setReportStatusDesc(WorkFlowStatusEnum.getByCode(reportVO.getReportStatus()) == null ? "" : WorkFlowStatusEnum.getByCode(reportVO.getReportStatus()).getDesc()));
        return reportVOS;
    }

    @Override
    public CrmActReportVO queryActReportDetail(Long key) {
        CrmActReportVO reportVO = dao.queryActReportDetail(key);
        reportVO.setProjectStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), reportVO.getProjectStatus()));
        return reportVO;
    }


    /**
     * 修改流程状态
     *
     * @param projectId  主键
     * @param status     流程状态
     * @param procInstId 流程实例id
     */
    @Override
    @Transactional(propagation = Propagation.REQUIRED)
    public void updateWorkFlowStatus(Long projectId, String status, String procInstId) {
        dao.updateStatus(projectId, status, procInstId);
    }

    @Override
    public Object changeLogList(Long activityId) {
        List<PrdSystemBusinessChangeVO> result = changeService.getChangeLogList(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), activityId.toString());
        for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : result) {
            prdSystemBusinessChangeVO.setCreateUserName(cacheUtil.getUserName(prdSystemBusinessChangeVO.getCreateUserId()));
        }
        return result;
    }


    @Override
    public Map<String, Object> changeLogDetailByActivityId(Long activityId) {
        Long currentVersionId = changeService.getCurrentVersionId(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), activityId.toString());
        Map<String, Object> changeLogDetail = changeService.getChangeLogDetail(currentVersionId, null);
        return changeLogDetail;
    }


    //判断是否可操作
    void checkUpdate(CrmActProjectVO project) {

        if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            throw TwException.error("", "该活动已暂挂");
        }
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVING_WORK.getCode())) {
            throw TwException.error("", "正在审批中。。。");
        }
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "活动已关闭");
        }
    }

    //全局翻译
    void transferSystemSelection(CrmActActivityVO vo) {
        vo.setManageUserName(cacheUtil.getUserName(vo.getManageUserId()));
        vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
        vo.setBudgetMoney(vo.getTotalMoney().subtract(vo.getPersonMoney()));
        vo.setProjectStatusName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getProjectStatus()));
        vo.setDetailTypeName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), vo.getDetailType()));
        vo.setCompanyName(cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeCompany.getCode(), vo.getCompanyId() + ""));

    }


    private void submitProc(CrmActActivityVO crmActActivityVO) {

        PrjProjectVO prjProjectVO = projectDAO.queryByKey(crmActActivityVO.getProjectId());
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            //获取企业战略规划及发展中心（P00），二级市场部部门负责人(P1MKT)
            Long strategicCenterUserId = daoOrg.queryManageIdByCode("P00");
            Long marketManageUserId = daoOrg.queryManageIdByCode("P1MKT");
            Long orgId = crmActActivityVO.getOrgId();
            //判断部门是否是销售管理中心下的部门
            Long actOrgManageUserId = null;
            PrdOrgOrganizationVO pvo = daoOrg.queryParentOrgById(orgId);
            if (pvo != null && pvo.getOrgName().equals("销售管理中心")) {
                actOrgManageUserId = daoOrg.queryManageIdById(pvo.getId());
            } else {
                actOrgManageUserId = daoOrg.queryManageIdById(orgId);
            }
            //部门负责人审批
            variables.put("Activity_1p6ou0f", CollUtil.newArrayList(actOrgManageUserId.toString()));
            //一级中心负责人
            variables.put("Activity_0yu9h7j", CollUtil.newArrayList(strategicCenterUserId.toString()));
            //二级市场部经理
            variables.put("Activity_1fzxus6", CollUtil.newArrayList(marketManageUserId.toString()));
            //预算金额判断
            BigDecimal purchaseMoney = crmActActivityVO.getPurchaseMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getPurchaseMoney();
            BigDecimal sundryMoney = crmActActivityVO.getSundryMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getSundryMoney();
            BigDecimal claimMoney = crmActActivityVO.getClaimMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getClaimMoney();
            BigDecimal add = purchaseMoney.add(sundryMoney).add(claimMoney);
            variables.put("haveBudget", add.compareTo(BigDecimal.ZERO) == 1);
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.MARKET_ACTIVITY.name(),
                    prjProjectVO.getProjectName() + "-市场活动审批流程",
                    crmActActivityVO.getId() + "",
                    variables)
            );
        }

        //流程启动成功后，回写业务表数据
        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
        activityPayload.setProcInstId(processInfo.getProcInstId());
        activityPayload.setId(crmActActivityVO.getId());
        activityPayload.setProcInstStatus(processInfo.getProcInstStatus());
        activityPayload.setSubmitTime(LocalDateTime.now());
        activityPayload.setProcDefKey(ProcDefKey.MARKET_ACTIVITY.name());
        //更新项目状态
        updateWorkFlowStatus(crmActActivityVO.getProjectId(), status, "");
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateActivityByKeyDynamic(activityPayload);
        });

    }


    private void submitReportProc(CrmActReportVO crmActReportVO) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
//        PrjProjectVO prjProjectVO = projectDAO.queryByKey(crmActReportVO.getProjectId());
            HashMap<String, Object> variables = new HashMap<>();
            //市场部部门负责人(P1MKT)
            Long marketManageUserId = daoOrg.queryManageIdByCode("P1MKT");
            //市场部经理
            variables.put("Activity_17yato4", CollUtil.newArrayList(marketManageUserId.toString()));
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.MARKET_END_REPORT.name(),
                    crmActReportVO.getProjectName() + "-市场活动结项报告审批流程",
                    crmActReportVO.getId() + "",
                    variables)
            );
        }

        //流程启动成功后，回写业务表数据
        CrmActReportPayload reportPayload = new CrmActReportPayload();
        reportPayload.setProcInstId(processInfo.getProcInstId());
        reportPayload.setId(crmActReportVO.getId());
        reportPayload.setProcInstStatus(processInfo.getProcInstStatus());
        reportPayload.setSubmitTime(LocalDateTime.now());
        reportPayload.setReportStatus(status);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateReportyKeyDynamic(reportPayload);
        });
    }


    private void submitChangeProc(CrmActActivityVO crmActActivityVO) {
        PrjProjectVO prjProjectVO = projectDAO.queryByKey(crmActActivityVO.getProjectId());
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            //获取企业战略规划及发展中心（P00），二级市场部部门负责人(P1MKT)
            Long strategicCenterUserId = daoOrg.queryManageIdByCode("P00");
            Long marketManageUserId = daoOrg.queryManageIdByCode("P1MKT");
            Long orgId = crmActActivityVO.getOrgId();
//        Long actOrgManageUserId = daoOrg.queryManageIdById(orgId);
            //判断部门是否是销售管理中心下的部门
            Long actOrgManageUserId = null;
            PrdOrgOrganizationVO pvo = daoOrg.queryParentOrgById(orgId);
            if (pvo != null && pvo.getOrgName().equals("销售管理中心")) {
                actOrgManageUserId = daoOrg.queryManageIdById(pvo.getId());
            } else {
                actOrgManageUserId = daoOrg.queryManageIdById(orgId);
            }
            //部门负责人审批
            variables.put("Activity_1x8di82", CollUtil.newArrayList(actOrgManageUserId.toString()));
            //一级中心负责人
            variables.put("Activity_1n8w14o", CollUtil.newArrayList(strategicCenterUserId.toString()));
            //二级市场部经理
            variables.put("Activity_1re8zas", CollUtil.newArrayList(marketManageUserId.toString()));
            //预算金额判断
            BigDecimal purchaseMoney = crmActActivityVO.getPurchaseMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getPurchaseMoney();
            BigDecimal sundryMoney = crmActActivityVO.getSundryMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getSundryMoney();
            BigDecimal claimMoney = crmActActivityVO.getClaimMoney() == null ? BigDecimal.ZERO : crmActActivityVO.getClaimMoney();
            BigDecimal add = purchaseMoney.add(sundryMoney).add(claimMoney);
            variables.put("haveBudget", add.compareTo(BigDecimal.ZERO) == 1);
//        variables.put("haveBudget",purchaseMoney.add(sundryMoney).add(claimMoney).compareTo(BigDecimal.ZERO)==1);
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.MARKET_ACTIVITY_C.name(),
                    prjProjectVO.getProjectName() + "-市场活动变更流程",
                    crmActActivityVO.getId() + "",
                    variables)
            );
        }

        //流程启动成功后，回写业务表数据
        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
        activityPayload.setProcInstId(processInfo.getProcInstId());
        activityPayload.setId(crmActActivityVO.getId());
        activityPayload.setProcInstStatus(processInfo.getProcInstStatus());
        activityPayload.setSubmitTime(LocalDateTime.now());
        activityPayload.setProcDefKey(ProcDefKey.MARKET_ACTIVITY_C.name());
        //更新项目状态
        updateWorkFlowStatus(crmActActivityVO.getProjectId(), status, "");
        // 更新流程相关数据
        List<PrdSystemBusinessChangeVO> changeLogList = changeService.getChangeLogList(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), crmActActivityVO.getId().toString());
        if (changeLogList != null && !changeLogList.isEmpty()) {
            PrdSystemBusinessChangeVO initVersion = new PrdSystemBusinessChangeVO();
            //TODO:后面整理一下公共方法
            for (PrdSystemBusinessChangeVO prdSystemBusinessChangeVO : changeLogList) {
                if (prdSystemBusinessChangeVO.getVersionNo() == 0) {
                    initVersion = prdSystemBusinessChangeVO;
                }
            }
            //TODO:未更新成功
            String versionContent = initVersion.getVersionContent();
            Map<String, Object> versionContentMap = JSON.parseObject(versionContent);
            versionContentMap.put("procInsId", processInfo.getProcInstId());
            versionContentMap.put("procInstStatus", processInfo.getProcInstStatus());
            versionContentMap.put("procDefKey", ProcDefKey.MARKET_ACTIVITY_C.name());
            versionContent = JSON.toJSONString(versionContentMap);
            PrdSystemBusinessChangePayload changePayload = new PrdSystemBusinessChangePayload();
            changePayload.setVersionContent(versionContent);
            changePayload.setId(initVersion.getId());
            changeDAO.updateByKeyDynamic(changePayload);
        }
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateActivityByKeyDynamic(activityPayload);
        });
    }

    @Override
    public List<CrmActActivityVO> queryListDynamic(CrmActActivityQuery query) {
        return dao.queryList(query);
    }

    @Override
    public void updateSchedule(Long id, Long scheduleId) {
        dao.updateSchedule(id, scheduleId);
    }

}
