package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationChancePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationChanceService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationChanceConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationChanceDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationChanceDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationChanceRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationRepo;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 人脉经营-经营机会点
 *
 * @author carl
 * @date 2022/11/21
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustomerOperationChanceServiceImpl implements CrmCustomerOperationChanceService {

    private final CrmCustomerOperationChanceRepo repo;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CrmCustomerOperationChanceDAO dao;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final CrmCustomerOperationRepo repoCustomerOperation;
    private final PrdCommentService prdCommentService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final CrmPeopleService peopleService;
    private final CrmCustomerOperationRepo customerOperationRepo;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CrmCustomerOperationChanceVO insertOrUpdate(CrmCustomerOperationChancePayload payload) {
        // 校验
        check(payload);
        CrmCustomerOperationChanceDO entityDo = CrmCustomerOperationChanceConvert.INSTANCE.toDo(payload);
        String firstName = GlobalUtil.getLoginUser().getFirstName();
        String name = PrdSystemLogEnum.CREATE.getDesc();
        if (payload.getId() == null) {
            entityDo.setIsRead(0);
            entityDo = repo.save(entityDo);
            //发送知会人企业微信信息
            sendQwxMessage(entityDo, null, firstName);
            logService.saveNewLog(entityDo.getId(),
                    PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getCode(), "(" + firstName + ")" +
                            name + PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getDesc());
        } else {
            name = PrdSystemLogEnum.UPDATE.getDesc();
            Optional<CrmCustomerOperationChanceDO> chanceDO = repo.findById(payload.getId());
            if (chanceDO.isPresent()) {
                CrmCustomerOperationChanceDO crmCustomerOperationChanceDO = chanceDO.get();
                entityDo.setInvolvedUserIds(crmCustomerOperationChanceDO.getInvolvedUserIds());
                if (crmCustomerOperationChanceDO.getTrackerUserId() == null) {
                    entityDo.setIsRead(0);
                } else {
                    if (entityDo.getTrackerUserId() != null && !entityDo.getTrackerUserId().equals(crmCustomerOperationChanceDO.getTrackerUserId())) {
                        entityDo.setIsRead(0);
                    }
                }
                CrmCustomerOperationChanceDO entityLog = new CrmCustomerOperationChanceDO();
                BeanUtils.copyProperties(crmCustomerOperationChanceDO, entityLog);
                crmCustomerOperationChanceDO.copy(entityDo);

                // 修改NULL值特殊处理
                final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, crmCustomerOperationChanceDO);
                //  dao.update(payload);
                repo.save(crmCustomerOperationChanceDO);
                //获取变更日志
                fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
                if (StringUtils.hasText(fieldsUpdateLog)) {
                    logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getCode(), fieldsUpdateLog.toString());
                }
                //发送知会人企业微信信息
                sendQwxMessage(entityDo, entityLog, firstName);
            } else {
                throw TwException.error("", "更新数据不存在，请核验！");
            }
        }
        logService.saveNewLog(entityDo.getOperId(),
                PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(),
                name + PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getDesc());

        return CrmCustomerOperationChanceConvert.INSTANCE.toVo(entityDo);
    }

    /**
     * 知会人发送企业微信信息
     *
     * @param newDo
     * @param oldDo
     * @param firstName
     */
    void sendQwxMessage(CrmCustomerOperationChanceDO newDo, CrmCustomerOperationChanceDO oldDo, String firstName) {
        if (StringUtils.hasText(newDo.getInformUserIds())) {
            if (oldDo == null || !StringUtils.hasText(oldDo.getInformUserIds())) {
                CrmCustomerOperationDO entity = repoCustomerOperation.findById(newDo.getOperId()).orElseGet(CrmCustomerOperationDO::new);
                Assert.notNull(entity.getId(), "不存在");
                String[] split = newDo.getInformUserIds().split(",");
                List<Long> informUserIds = Arrays.asList(split).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toList());
                String content = firstName + "在“" + entity.getCustName() + "--" + newDo.getTitle() + "“知会了你";
                qyWxCommunicationService.sendMessageToUser(informUserIds, content);
            } else {
                if (!newDo.getInformUserIds().equals(oldDo.getInformUserIds())) {
                    List<Long> informUserIds = new ArrayList<>();
                    String[] split = newDo.getInformUserIds().split(",");
                    for (int i = 0; i < split.length; i++) {
                        if (!oldDo.getInformUserIds().contains(split[i])) {
                            informUserIds.add(Long.valueOf(split[i].trim()));
                        }
                    }
                    if (informUserIds.size() > 0) {
                        CrmCustomerOperationDO entity = repoCustomerOperation.findById(newDo.getOperId()).orElseGet(CrmCustomerOperationDO::new);
                        Assert.notNull(entity.getId(), "不存在");
                        String content = firstName + "在“" + entity.getCustName() + "--" + newDo.getTitle() + "“知会了你";
                        qyWxCommunicationService.sendMessageToUser(informUserIds, content);
                    }
                }
            }
        }

    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CrmCustomerOperationChanceVO queryByKey(Long key) {
        CrmCustomerOperationChanceVO crmCustomerOperationChanceVO = dao.queryByKey(key);
        //翻译数据
        transferData(crmCustomerOperationChanceVO);
        //如果跟踪人是自己，并且未读，则直接修改为已读
        if (crmCustomerOperationChanceVO.getTrackerUserId() != null) {
            if (GlobalUtil.getLoginUserId().compareTo(crmCustomerOperationChanceVO.getTrackerUserId()) == 0 && crmCustomerOperationChanceVO.getIsRead() == 0) {
                repo.updateIsRead(GlobalUtil.getLoginUserId(), List.of(crmCustomerOperationChanceVO.getId()));
            }
        }
        if (crmCustomerOperationChanceVO.getOperId() != null){
            Optional<CrmCustomerOperationDO> operOptional = customerOperationRepo.findById(crmCustomerOperationChanceVO.getOperId());
            if (operOptional.isPresent()){
                crmCustomerOperationChanceVO.setCustOperStatus(operOptional.get().getCustOperStatus());
            }
        }
        return crmCustomerOperationChanceVO;
    }

    @Override
    public List<CrmCustomerOperationChanceVO> queryList(Long operId) {
        if (ObjectUtils.isEmpty(operId)) {
            throw TwException.error("", "operId不能为空");
        }
        List<CrmCustomerOperationChanceVO> operationChanceVOS = dao.queryList(operId);
        operationChanceVOS.forEach(operationChanceVO -> transferData(operationChanceVO));
        return operationChanceVOS;
    }

    @Override
    public PagingVO<CrmCustomerOperationChanceVO> paging(CrmCustomerOperationChanceQuery query) {
        //处理权限
        operPermissionFlag(query);
        PagingVO<CrmCustomerOperationChanceVO> paging = dao.paging(query);
        paging.getRecords().forEach(operationChanceVO -> {
            transferData(operationChanceVO);
            // 统计评论个数
            operationChanceVO.setComments(prdCommentService.count(PrdCommentObjTypeEnum.OPER_CHANCE.getCode(), operationChanceVO.getId()));
            // 统计附件个数
            operationChanceVO.setFiles(prdFsmFileRefService.count(PrdCommentObjTypeEnum.OPER_CHANCE.getCode(), operationChanceVO.getId()));
        });
        return paging;
    }

    /**
     * 权限处理
     *
     * @param query
     */
    void operPermissionFlag(CrmCustomerOperationChanceQuery query) {
        //判断是否需要权限验证
        Boolean rolePermission = false;
        if (query.getOperId() != null) {
            //如果是客户经营下的分页查询不判断权限
            rolePermission = true;
        } else {
            rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
        }
        query.setNoPermissionFlag(rolePermission);
        if (!rolePermission) {
            //需要处理权限
            Long userId = GlobalUtil.getLoginUserId();
            query.setCreateUserId(GlobalUtil.getLoginUserId());
            //获取拥有权限的客户经营id
            List<Long> operationIds = peopleService.queryPermitOperationIds(userId);
            query.setOperationIds(operationIds);

        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void deleteSoft(List<Long> keys) {
        dao.deleteByIdIn(keys);
    }

    @Override
    public void deleteSoftByOperIds(List<Long> operIds) {
        dao.deleteSoftByOperIds(operIds);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateInvolvedUser(Long key, List<Long> userIds) {
        CrmCustomerOperationChanceVO crmCustomerOperationChanceVO = dao.queryByKey(key);
        String involvedUserIds = crmCustomerOperationChanceVO.getInvolvedUserIds();

        CrmCustomerOperationChancePayload payload = new CrmCustomerOperationChancePayload();
        payload.setId(crmCustomerOperationChanceVO.getId());

        String name = "添加了参与者（";
        if (StringUtils.hasText(involvedUserIds)) {
            String[] split = involvedUserIds.split(",");
            Set<Long> oldUserIds = Arrays.asList(split).stream().map(s -> Long.valueOf(s.trim())).collect(Collectors.toSet());
            boolean b = oldUserIds.containsAll(userIds);
            if (b) {
                name = "删除了参与者（";
                //表示删除操作
                oldUserIds.removeAll(userIds);
            } else {
                //添加操作
                oldUserIds.addAll(userIds);
            }
            if (oldUserIds.size() > 0) {
                involvedUserIds = oldUserIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            } else {
                involvedUserIds = null;
                payload.setNullFields(List.of("involvedUserIds"));
            }
        } else {
            involvedUserIds = userIds.stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        for (Long userId : userIds) {
            String userName = cacheUtil.getUserName(userId);
            name += userName + ",";
        }
        name = name.substring(0, name.length() - 1) + "）";
        payload.setInvolvedUserIds(involvedUserIds);
        dao.update(payload);
        logService.saveNewLog(key,
                PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getCode(), "(" + GlobalUtil.getLoginUser().getFirstName() + ")" +
                        name);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateIsRead(List<Long> keys) {
        repo.updateIsRead(GlobalUtil.getLoginUserId(), keys);
    }

    @Override
    public List<PrdSystemLogVO> queryLogList(Long id) {
        return logService.queryLogList(id, PrdSystemObjectEnum.CUSTOMER_OPERATION_CHANCE.getCode());
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(CrmCustomerOperationChancePayload payload) {
        if (null == payload.getOperId()) {
            throw TwException.error("", "operId不能为空");
        }
        if (null == payload.getTitle()) {
            throw TwException.error("", "标题不能为空");
        }
    }

    /**
     * 翻译数据
     *
     * @param vo
     */
    void transferData(CrmCustomerOperationChanceVO vo) {
        vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
        if (vo.getTrackerUserId() != null) {
            vo.setTrackerUserName(cacheUtil.getUserName(vo.getTrackerUserId()));
        }
        List<Map<String, Object>> involvedUsers = new ArrayList<>();
        if (StringUtils.hasText(vo.getInvolvedUserIds())) {
            String[] split = vo.getInvolvedUserIds().split(",");
            for (int i = 0; i < split.length; i++) {
                Long userId = Long.valueOf(split[i]);
                String userName = cacheUtil.getUserName(userId);
                Map<String, Object> user = new HashMap<>();
                user.put("userId", userId);
                user.put("userName", userName);
                involvedUsers.add(user);
            }
        }
        vo.setInvolvedUsers(involvedUsers);

        List<Map<String, Object>> informUsers = new ArrayList<>();
        if (StringUtils.hasText(vo.getInformUserIds())){
            for (String str: vo.getInformUserIds().split(",")){
                Long informUserId = Long.parseLong(str);
                String userName = cacheUtil.getUserName(informUserId);
                Map<String, Object> user = new HashMap<>();
                user.put("userId", informUserId);
                user.put("userName", userName);
                informUsers.add(user);
            }
        }
        vo.setInformUsers(informUsers);

        if (StringUtils.hasText(vo.getTags())) {
            //翻译标签列表
            List<PrdSystemTagVO> tagsDesc = new ArrayList<>();
            String[] tags = vo.getTags().split(",");
            for (String tag : tags) {
                List<PrdSystemTagVO> systemTags = cacheUtil.getSystemTag(Long.parseLong(tag));
                tagsDesc.addAll(systemTags);
            }
            vo.setTagsDesc(tagsDesc);
        }

    }

}
