package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationEmployeesPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationEmployeesQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationEmployeesService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationEmployeesVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationEmployeesConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationEmployeesDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationEmployeesRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
* 客户经营-企业工商主要人员
*
* @author duwh
* @date 2022-12-06
*/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmCustomerOperationEmployeesServiceImpl implements CrmCustomerOperationEmployeesService {

    private final CrmCustomerOperationEmployeesRepo crmCustomerOperationEmployeesRepo;

    @Override
    public PagingVO<CrmCustomerOperationEmployeesVO> paging(CrmCustomerOperationEmployeesQuery query){
        Page<CrmCustomerOperationEmployeesDO> page = crmCustomerOperationEmployeesRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder),query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmCustomerOperationEmployeesConvert.INSTANCE::toVo));
    }

    @Override
    public List<CrmCustomerOperationEmployeesVO> queryList(CrmCustomerOperationEmployeesQuery query){
        return CrmCustomerOperationEmployeesConvert.INSTANCE.toVoList(crmCustomerOperationEmployeesRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root,query,criteriaBuilder)));
    }

    @Override
    public CrmCustomerOperationEmployeesVO queryByKey(Long key) {
        CrmCustomerOperationEmployeesDO entity = crmCustomerOperationEmployeesRepo.findById(key).orElseGet(CrmCustomerOperationEmployeesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmCustomerOperationEmployeesVO vo = CrmCustomerOperationEmployeesConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmCustomerOperationEmployeesVO insert(CrmCustomerOperationEmployeesPayload payload) {
        CrmCustomerOperationEmployeesDO entityDo = CrmCustomerOperationEmployeesConvert.INSTANCE.toDo(payload);
        return CrmCustomerOperationEmployeesConvert.INSTANCE.toVo(crmCustomerOperationEmployeesRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmCustomerOperationEmployeesVO update(CrmCustomerOperationEmployeesPayload payload) {
        CrmCustomerOperationEmployeesDO entity = crmCustomerOperationEmployeesRepo.findById(payload.getId()).orElseGet(CrmCustomerOperationEmployeesDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmCustomerOperationEmployeesDO entityDo = CrmCustomerOperationEmployeesConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmCustomerOperationEmployeesConvert.INSTANCE.toVo(crmCustomerOperationEmployeesRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            crmCustomerOperationEmployeesRepo.deleteSoft(keys);
        }
    }

    @Override
    public void download(List<CrmCustomerOperationEmployeesVO> all, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = new ArrayList<>();
        for (CrmCustomerOperationEmployeesVO crmCustomerOperationEmployees : all) {
            Map<String,Object> map = new LinkedHashMap<>();
            map.put("客户经营主键", crmCustomerOperationEmployees.getOperId());
            map.put("主要人员姓名", crmCustomerOperationEmployees.getName());
            map.put("主要人员职位", crmCustomerOperationEmployees.getTitle());
            map.put("是否历史，是否历史；0：否1：是", crmCustomerOperationEmployees.getIsHistory());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }
}
