package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaAdminPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpenseaService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaAdminVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaMembersVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpenseaConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpenseaDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPotentialCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/14 - 12:25
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpenseaServiceImpl implements CrmOpenseaService {

    private final CrmOpenseaDAO dao;
    private final CrmPotentialCustomerDAO potentialCustomerDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;

    //    @Transactional
    @Override
    public CrmOpenseaVO saveOne(CrmOpenseaPayload payload) {
        CrmOpenseaDO ado = CrmOpenseaConvert.INSTANCE.toDo(payload);
        try {
            ado = dao.save(ado);
        } catch (Exception e) {
            throw TwException.error("", "公海名称不能重复！");
        }

        return CrmOpenseaConvert.INSTANCE.toVo(ado);
    }


    @Override
    public List<CrmOpenseaListVO> queryListMy() {
        // 获取当前登录用户
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();

        // 判断当前登录人是否是系统管理员or市场管理员
        List<Long> userIdsByRole = systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.MARKET_ADMIN.getCode()));
        CrmOpenseaQuery query = new CrmOpenseaQuery();
        if (userIdsByRole == null || userIdsByRole.isEmpty() || !userIdsByRole.contains(userId)) {
            query.setOpenseaAdminId(userId);
        }
        return queryList(query);
    }


    @Override
    public List<CrmOpenseaListVO> queryList(CrmOpenseaQuery query) {
        Specification<CrmOpenseaDO> spec = dao.getSpec(query);
        List<CrmOpenseaDO> all = dao.findAll(spec);
        return all.stream().map(e -> CrmOpenseaConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
    }

    @Transactional(readOnly = true)
    @Override
    public PagingVO<CrmOpenseaListVO> paging(CrmOpenseaQuery query) {
        Specification<CrmOpenseaDO> spec = dao.getSpec(query);
        Page<CrmOpenseaDO> all = dao.findAll(spec, query.getPageRequest());
        List<CrmOpenseaDO> content = all.getContent();
        List<CrmOpenseaListVO> collect = content.stream().map(e -> CrmOpenseaConvert.INSTANCE.toListVo(e)).collect(Collectors.toList());
        transferList(collect);
        //类型转化
        all.getTotalPages();
        PagingVO pagingVO = new PagingVO<>(all.getTotalElements(), collect);
        return pagingVO;
    }


    @Transactional
    @Override
    public CrmOpenseaVO queryDetail(Long id) {
        CrmOpenseaDO detail = dao.queryById(id);
        CrmOpenseaVO crmOpenseaVO = CrmOpenseaConvert.INSTANCE.toVo(detail);
        transferDetail(Collections.singletonList(crmOpenseaVO));
        return crmOpenseaVO;
    }

    @Override
    public void dynamicUpdate(CrmOpenseaPayload payload) {
        //执行更新
        dao.updateByKeyDynamic(payload);
    }


    private void transferList(List<CrmOpenseaListVO> list) {
        for (CrmOpenseaListVO vo : list) {
            if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
//            List<CrmOpenseaAdminVO> openseaAdmins = vo.getOpenseaAdmins();
//
//            List<CrmOpenseaMembersVO> openseaMembers = vo.getOpenseaMembers();
//            openseaMembers.stream().map(e->{
//                e.setUserName(cacheUtil.getUserName(e.getUserId()));
//                return e;
//            }).collect(Collectors.toList());
//            openseaAdmins.stream().map(e->{
//                e.setUserName(cacheUtil.getUserName(e.getUserId()));
//                return e;
//            }).collect(Collectors.toList());
        }
    }


    private void transferDetail(List<CrmOpenseaVO> list) {
        for (CrmOpenseaVO vo : list) {
            if (!ObjectUtils.isEmpty(vo.getCreateUserId())) {
                vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
            }
            List<CrmOpenseaAdminVO> openseaAdmins = vo.getOpenseaAdmins();

            List<CrmOpenseaMembersVO> openseaMembers = vo.getOpenseaMembers();

            openseaMembers.stream().map(e -> {
                e.setUserName(cacheUtil.getUserName(e.getUserId()));
                return e;
            }).collect(Collectors.toList());
            openseaAdmins.stream().map(e -> {
                e.setUserName(cacheUtil.getUserName(e.getUserId()));
                return e;
            }).collect(Collectors.toList());
        }
    }


    @Override
    @Transactional
    public void importOpensea(MultipartFile file) {

        if (file == null) {
            throw TwException.error("", "上传文件异常");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create(file.getInputStream());
        } catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "文件解析异常");
        }
        Sheet sheet = workbook.getSheet("公海数据");
        if (sheet == null) {
            throw TwException.error("", "表结构错误");
        }
        int dataStartRow = 1;
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); i++) {
            Row row = sheet.getRow(i);
            CrmOpenseaPayload openseaPayload = new CrmOpenseaPayload();
            List<CrmOpenseaMembersPayload> membersPayloads = new ArrayList<>();
            List<CrmOpenseaAdminPayload> adminPayloads = new ArrayList<>();

            openseaPayload.setOpenseaName(ExcelUtil.getCellFormatValue(row.getCell(1)));
            String offshoreMembersStr = ExcelUtil.getCellFormatValue(row.getCell(2));
            String offshoreAdminsStr = ExcelUtil.getCellFormatValue(row.getCell(3));

            if (StringUtils.hasText(offshoreMembersStr)) {
                String[] members = offshoreMembersStr.split(",");
                List<Long> collect = Arrays.stream(members).map(e -> Long.parseLong(e)).collect(Collectors.toList());
                List<Long> memberUserIds = employeeDAO.queryUserIdByEmployeeNo(collect);
                membersPayloads = memberUserIds.stream().map(e -> {
                    CrmOpenseaMembersPayload membersPayload = new CrmOpenseaMembersPayload();
                    membersPayload.setUserId(e);
                    return membersPayload;
                }).collect(Collectors.toList());
                openseaPayload.setOpenseaMembers(membersPayloads);
            }
            if (StringUtils.hasText(offshoreAdminsStr)) {
                String[] admins = offshoreAdminsStr.split(",");
                List<Long> collect = Arrays.stream(admins).map(e -> Long.parseLong(e)).collect(Collectors.toList());
                List<Long> adminUserIds = employeeDAO.queryUserIdByEmployeeNo(collect);
                adminPayloads = adminUserIds.stream().map(e -> {
                    CrmOpenseaAdminPayload adminPayload = new CrmOpenseaAdminPayload();
                    adminPayload.setUserId(e);
                    return adminPayload;
                }).collect(Collectors.toList());
                openseaPayload.setOpenseaAdmins(adminPayloads);
            }
            saveOne(openseaPayload);
        }
    }

    @Override
    public void downloadOpensea(HttpServletResponse response, CrmOpenseaQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/openseaBatch.xlsx");
        PagingVO<CrmOpenseaListVO> paging = paging(query);
        List<CrmOpenseaListVO> records = paging.getRecords();
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create(inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet) workbook.getSheet("公海数据");

            //  excelUtil.generateRangeList(batchProjectSheet, 2, 2, "活动类型", 2, "A"); // 最终客户 数据验证

            if (!CollectionUtils.isEmpty(records) && batchProjectSheet != null) {
                int nextRow = 2;
                for (CrmOpenseaListVO dataPayload : records) {
                    Row row = batchProjectSheet.createRow(nextRow);
                    excelUtil.setCellValue(row, 0, nextRow); // 序号
                    excelUtil.setCellValue(row, 1, dataPayload.getOpenseaName());// 近海名称
                    excelUtil.setCellValue(row, 3, dataPayload.getCustomerNum());// 潜在客户个数
//                    List<CrmOpenseaMembersVO> openseaMembers = dataPayload.getOpenseaMembers();
//                    List<CrmOpenseaAdminVO> openseaAdmins = dataPayload.getOpenseaAdmins();
//                    List<String> collect = openseaMembers.stream().map(e -> {
//                        Long userId = e.getUserId();
//                        return cacheUtil.getUserName(userId);
//                    }).collect(Collectors.toList());
//                    String members = String.join(",", collect);
//                    excelUtil.setCellValue(row, 2, members);// 公海成员

//                    List<String> adminList = openseaAdmins.stream().map(e -> {
//                        Long userId = e.getUserId();
//                        return cacheUtil.getUserName(userId);
//                    }).collect(Collectors.toList());
//                    String admins = String.join(",", collect);
//                    excelUtil.setCellValue(row, 3, admins);// 公海管理员
                    nextRow++;
                }
            }

            String fileName = "近海数据-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
