package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityOutCostPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityOutCostService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityOutCostVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityOutCostConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityOutCostDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityOutCostDO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author carl.wang
 * @Description 商机渠道（外包）费用
 * @Date 20220527
 **/
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityOutCostServiceImpl implements CrmOpportunityOutCostService {
    private final CacheUtil cacheUtil;
    private final CrmOpportunityOutCostDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final CrmOpportunityService crmOpportunityService;
    private final CrmOpportunityDAO crmOpportunityDAO;
    private final TransactionUtilService transactionUtilService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final WorkflowUtil workflowUtil;

    @Value("${tw4.opportunity.outCost_operation}")
    private String outCost_operation;

    @Value("${tw4.opportunity.outCost_del}")
    private String outCost_del;

    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CrmOpportunityOutCostVO insert(CrmOpportunityOutCostPayload payload) {
        //同步到4.0
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
        // 获取当前登录用户
//        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
//        Long userId = userDetails == null ? 0 : userDetails.getUser().getId();
//        map.put("createUserId", employeeDAO.getV4UserId(userId));
//        String result = httpUtil.sendSyncPost(outCost_operation, map);
//        String outCostId = httpUtil.geResultData(result);
//        long outCostIdV4 = 0;
//        if (StringUtils.hasText(outCostId)) {
//            if (StringUtil.isInteger(outCostId)) {
//                outCostIdV4 = Long.valueOf(outCostId);
//            }
//        }
        CrmOpportunityOutCostDO ado = CrmOpportunityOutCostConvert.INSTANCE.toDo(payload);
//        ado.setOutCostIdV4(outCostIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + "外包费用");
        return CrmOpportunityOutCostConvert.INSTANCE.toVo(ado);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Long update(CrmOpportunityOutCostPayload payload) {
        //同步到4.0
//        Long outCostIdV4 = dao.queryTW4IdById(payload.getId());
//        Map<String, Object> map = transferUtilService.beanToMap(payload);
//        map.put("id", outCostIdV4);
//        String result = httpUtil.sendSyncPost(outCost_operation, map);
//        httpUtil.geResultData(result);
        CrmOpportunityOutCostDO ado = CrmOpportunityOutCostConvert.INSTANCE.toDo(payload);
//        ado.setOutCostIdV4(outCostIdV4);
        dao.save(ado);
        logService.saveNewLog(payload.getOppoId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + "外包费用");
        return 0L;
    }

    @Override
    public CrmOpportunityOutCostVO queryById(Long id) {
        final CrmOpportunityOutCostVO vo = dao.queryById(id);
//        vo.setApplyUserName(vo.getCreator());
        if (StringUtils.hasText(vo.getApprovalStatus())) {
            final WorkFlowStatusEnum byCode = WorkFlowStatusEnum.getByCode(vo.getApprovalStatus());
            vo.setApprovalStatusName(null != byCode ? byCode.getDesc() : "");
        }
        return vo;
    }

    @Override
    public List<CrmOpportunityOutCostVO> queryList(Long oppoId) {
        final List<CrmOpportunityOutCostVO> list = dao.queryList(oppoId);
        if (!CollectionUtils.isEmpty(list)) {
            for (CrmOpportunityOutCostVO vo : list) {
//                vo.setApplyUserName(vo.getCreator());

                if (StringUtils.hasText(vo.getApprovalStatus())) {
                    final WorkFlowStatusEnum byCode = WorkFlowStatusEnum.getByCode(vo.getApprovalStatus());
                    vo.setApprovalStatusName(null != byCode ? byCode.getDesc() : "");
                }
            }
        }
        return list;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteSoft(Long oppoId, List<Long> keys) {
        //同步到4.0
//        Map<String, Object> map = new HashMap<>();
//        map.put("ids", org.apache.commons.lang3.StringUtils.join(dao.queryTW4IdsByIds(keys), ","));
//        String result = httpUtil.sendSyncGet(outCost_del, map);
//        httpUtil.geResultData(result);
        dao.deleteSoft(keys);
        logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.DELETE.getDesc() + "外包费用");
        return true;
    }

    @Override
    public void submit(Long id) {
        final CrmOpportunityOutCostVO crmOpportunityOutCostVO = dao.queryById(id);
        if (crmOpportunityOutCostVO == null) {
            throw TwException.error("", "未找到相关的数据");
        } else if (crmOpportunityOutCostVO.getProcInstStatus() != null && !crmOpportunityOutCostVO.getProcInstStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            throw TwException.error("", "仅新增状态可操作");
        }
        submitProc(crmOpportunityOutCostVO);
    }


    /**
     * 提交
     *
     * @param vo 签证官
     */
    private void submitProc(CrmOpportunityOutCostVO vo) {
        final Long oppoId = vo.getOppoId();
        final CrmOpportunityVO crmOpportunityVO = crmOpportunityDAO.queryByKey(oppoId);
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();
            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.OPPO_OUT_COST.name(),
                    crmOpportunityVO.getProjectName() + "-商机外包费用审批流程",
                    vo.getId() + "",
                    variables)
            );
        }

        //流程启动成功后，回写业务表数据
        CrmOpportunityOutCostPayload payload = new CrmOpportunityOutCostPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(vo.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApprovalStatus(status);

        //同步到4.0
//        Long outCostIdV4 = dao.queryTW4IdById(vo.getId());
//        vo.setApprovalStatus(status);
//        Map<String, Object> map = transferUtilService.beanToMap(vo);
//        map.put("id", outCostIdV4);
//        String result = httpUtil.sendSyncPost(outCost_operation, map);
//        httpUtil.geResultData(result);
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            dao.updateByKeyDynamic(payload);
        });


    }
}
