package com.elitesland.tw.tw5.server.prd.humanresources.basebu.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseBuChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBuChangeTodoService;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdBuChangeTodoConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.entity.PrdBuChangeTodoDO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBuChangeTodoPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdBuChangeTodoQuery;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.repo.PrdBuChangeTodoRepo;
import com.elitesland.tw.tw5.server.prd.humanresources.basebu.dao.PrdBuChangeTodoDao;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBuChangeTodoVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-7
 * @desc : baseBU变更待办事项Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdBuChangeTodoServiceImpl implements PrdBuChangeTodoService {


    private final PrdBuChangeTodoDao prdBuChangeTodoDao;

    private final PrdBuChangeTodoRepo prdBuChangeTodoRepo;

    @Lazy
    @Autowired
    private PrdBaseBuChangeService prdBaseBuChangeService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean save(PrdBuChangeTodoPayload prdBuChangeTodoPayload) {

        checkData(prdBuChangeTodoPayload);
        for (int i = 0; i < 4; i++) {
            PrdBuChangeTodoDO prdBuChangeTodoDO = new PrdBuChangeTodoDO();
            prdBuChangeTodoDO = PrdBuChangeTodoConvert.INSTANCE.p2d(prdBuChangeTodoPayload);
            prdBuChangeTodoDO.setTodoTitle(i);
            prdBuChangeTodoDO.setTodoDesc(i);
            prdBuChangeTodoDO.setState(0);
            PrdBuChangeTodoDO res = prdBuChangeTodoRepo.save(prdBuChangeTodoDO);
        }
        return true;

    }


//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public PrdBuChangeTodoVO update(PrdBuChangeTodoPayload prdBuChangeTodoPayload) {
//
//        Assert.notNull(prdBuChangeTodoPayload.getId(), "id is null");
//        PrdBuChangeTodoVO res = save(prdBuChangeTodoPayload);
//        return res;
//
//    }


    @Override
    public PrdBuChangeTodoVO get(Long id) {

        if (null == id) {
            return null;
        }
        PrdBuChangeTodoVO res = prdBuChangeTodoDao.get(id);
        return res;

    }


    @Override
    public PagingVO<PrdBuChangeTodoVO> page(PrdBuChangeTodoQuery prdBuChangeTodoQuery) {

        PagingVO<PrdBuChangeTodoVO> res = prdBuChangeTodoDao.page(prdBuChangeTodoQuery);
        return res;

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {

        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdBuChangeTodoDao.del(ids);
        return res;

    }

    @Override
    public List<PrdBuChangeTodoVO> getList(PrdBuChangeTodoQuery prdBuChangeTodoQuery, Long userId) {

        List<PrdBuChangeTodoVO> res = prdBuChangeTodoDao.getList(prdBuChangeTodoQuery);
        prdBaseBuChangeService.updateState(res, userId);
        return res;

    }

    @Override
    @Transactional
    public Long updateByCondition(PrdBuChangeTodoPayload prdBuChangeTodoPayload) {

        Assert.notNull(prdBuChangeTodoPayload.getId(), "id不能为空");
        Assert.notNull(prdBuChangeTodoPayload.getState(), "state不能为空");
        Long res = prdBuChangeTodoDao.update(prdBuChangeTodoPayload);
        return res;
    }

    @Override
    @Transactional
    public Boolean updateByBatch(List<PrdBuChangeTodoPayload> prdBuChangeTodoPayloadList) {
        for (PrdBuChangeTodoPayload prdBuChangeTodoPayload : prdBuChangeTodoPayloadList) {
            updateByCondition(prdBuChangeTodoPayload);
        }
        return true;
    }


    /**
     * 数据校验
     *
     * @param prdBuChangeTodoPayload
     */
    private void checkData(PrdBuChangeTodoPayload prdBuChangeTodoPayload) {

//        if (StringUtils.isBlank(prdBuChangeTodoPayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }
        Assert.notNull(prdBuChangeTodoPayload.getChangeId(), "changeId不能为空");

    }


}

