package com.elitesland.tw.tw5.server.prd.humanresources.eval.dao;

import cn.hutool.core.collection.CollUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigVO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateConfigDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.QPrdEvaluateConfigDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置表RepoProc
 */

@Component
public class PrdEvaluateConfigDao extends BaseRepoProc<PrdEvaluateConfigDO> {

    private static final QPrdEvaluateConfigDO qPrdEvaluateConfigDO = QPrdEvaluateConfigDO.prdEvaluateConfigDO;


    protected PrdEvaluateConfigDao() {

        super(qPrdEvaluateConfigDO);

    }


    public PagingVO<PrdEvaluateConfigVO> page(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        JPAQuery<PrdEvaluateConfigVO> query =
                select(PrdEvaluateConfigVO.class)
                        .where(bulidPredicate(prdEvaluateConfigQuery));
        prdEvaluateConfigQuery.setPaging(query);
        prdEvaluateConfigQuery.fillOrders(query, qPrdEvaluateConfigDO);
        return PagingVO.<PrdEvaluateConfigVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdEvaluateConfigDO)
                .set(qPrdEvaluateConfigDO.deleteFlag, 1)
                .where(qPrdEvaluateConfigDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdEvaluateConfigVO get(Long id) {

        PrdEvaluateConfigVO prdEvaluateConfigVO = select(PrdEvaluateConfigVO.class)
                .where(qPrdEvaluateConfigDO.id.eq(id))
                .fetchOne();

        return prdEvaluateConfigVO;

    }


    public List<PrdEvaluateConfigVO> getList(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        List<PrdEvaluateConfigVO> res =
                select(PrdEvaluateConfigVO.class)
                        .where(bulidPredicate(prdEvaluateConfigQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdEvaluateConfigDO.cate,
                        qPrdEvaluateConfigDO.type,
                        qPrdEvaluateConfigDO.standardDesc,
                        qPrdEvaluateConfigDO.id,
                        qPrdEvaluateConfigDO.createTime,
                        qPrdEvaluateConfigDO.remark

                )).from(qPrdEvaluateConfigDO);

    }


    private Predicate bulidPredicate(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(StringUtils.isNotBlank(prdEvaluateConfigQuery.getCate()), qPrdEvaluateConfigDO.cate, prdEvaluateConfigQuery.getCate())
                .andEq(StringUtils.isNotBlank(prdEvaluateConfigQuery.getType()), qPrdEvaluateConfigDO.type, prdEvaluateConfigQuery.getType())
                .andEq(StringUtils.isNotBlank(prdEvaluateConfigQuery.getStandardDesc()), qPrdEvaluateConfigDO.standardDesc, prdEvaluateConfigQuery.getStandardDesc())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 类别
        if (StringUtils.isNotEmpty(prdEvaluateConfigQuery.getCate())) {
            predicates.add(qPrdEvaluateConfigDO.cate.eq(prdEvaluateConfigQuery.getCate()));
        }
        // 类型
        if (StringUtils.isNotEmpty(prdEvaluateConfigQuery.getType())) {
            predicates.add(qPrdEvaluateConfigDO.type.eq(prdEvaluateConfigQuery.getType()));
        }
        // 标准说明
        if (StringUtils.isNotEmpty(prdEvaluateConfigQuery.getStandardDesc())) {
            predicates.add(qPrdEvaluateConfigDO.standardDesc.eq(prdEvaluateConfigQuery.getStandardDesc()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {

        long res = select(PrdEvaluateConfigVO.class)
                .where(bulidPredicate(prdEvaluateConfigQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdEvaluateConfigPayload prdEvaluateConfigPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEvaluateConfigDO);

        // 类别
        if (StringUtils.isNotEmpty(prdEvaluateConfigPayload.getCate())) {
            update.set(qPrdEvaluateConfigDO.cate, prdEvaluateConfigPayload.getCate());
        }
        // 类型
        if (StringUtils.isNotEmpty(prdEvaluateConfigPayload.getType())) {
            update.set(qPrdEvaluateConfigDO.type, prdEvaluateConfigPayload.getType());
        }
        // 标准说明
        if (StringUtils.isNotEmpty(prdEvaluateConfigPayload.getStandardDesc())) {
            update.set(qPrdEvaluateConfigDO.standardDesc, prdEvaluateConfigPayload.getStandardDesc());
        }
        long res = update.where(qPrdEvaluateConfigDO.id.eq(prdEvaluateConfigPayload.getId()))
                .execute();
        return res;

    }


    public PrdEvaluateConfigVO getByCondition(PrdEvaluateConfigQuery prdEvaluateConfigQuery) {
        List<PrdEvaluateConfigVO> fetch = select(PrdEvaluateConfigVO.class)
                .where(bulidPredicate(prdEvaluateConfigQuery))
                .fetch();
        if (CollUtil.isNotEmpty(fetch)){
            return fetch.get(0);
        }
        return null;

    }

}

