package com.elitesland.tw.tw5.server.prd.humanresources.eval.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigDtlPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigDtlVO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.PrdEvaluateConfigDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.QPrdEvaluateConfigDtlDO;
import com.elitesland.tw.tw5.server.prd.humanresources.eval.entity.QPrdEvaluateConfigPointDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置明细表RepoProc
 */

@Component
public class PrdEvaluateConfigDtlDao extends BaseRepoProc<PrdEvaluateConfigDtlDO> {

    private static final QPrdEvaluateConfigDtlDO qPrdEvaluateConfigDtlDO = QPrdEvaluateConfigDtlDO.prdEvaluateConfigDtlDO;

    private static final QPrdEvaluateConfigPointDO qPrdEvaluateConfigPointDO = QPrdEvaluateConfigPointDO.prdEvaluateConfigPointDO;


    protected PrdEvaluateConfigDtlDao() {

        super(qPrdEvaluateConfigDtlDO);

    }


    public PagingVO<PrdEvaluateConfigDtlVO> page(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery) {

        JPAQuery<PrdEvaluateConfigDtlVO> query =
                select(PrdEvaluateConfigDtlVO.class)
                        .where(bulidPredicate(prdEvaluateConfigDtlQuery));
        prdEvaluateConfigDtlQuery.setPaging(query);
        prdEvaluateConfigDtlQuery.fillOrders(query, qPrdEvaluateConfigDtlDO);
        return PagingVO.<PrdEvaluateConfigDtlVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdEvaluateConfigDtlDO)
                .set(qPrdEvaluateConfigDtlDO.deleteFlag, 1)
                .where(qPrdEvaluateConfigDtlDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdEvaluateConfigDtlVO get(Long id) {

        PrdEvaluateConfigDtlVO prdEvaluateConfigDtlVO = select(PrdEvaluateConfigDtlVO.class)
                .where(qPrdEvaluateConfigDtlDO.id.eq(id))
                .fetchOne();

        return prdEvaluateConfigDtlVO;

    }


    public List<PrdEvaluateConfigDtlVO> getList(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery) {

        List<PrdEvaluateConfigDtlVO> res =
                select(PrdEvaluateConfigDtlVO.class)
                        .where(bulidPredicate(prdEvaluateConfigDtlQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                                qPrdEvaluateConfigDtlDO.configId,
                                qPrdEvaluateConfigDtlDO.pointId,
                                qPrdEvaluateConfigDtlDO.id,
                                qPrdEvaluateConfigDtlDO.createTime,
                                qPrdEvaluateConfigDtlDO.remark,
                                qPrdEvaluateConfigPointDO.name,
                                qPrdEvaluateConfigPointDO.state,
                                qPrdEvaluateConfigPointDO.scoreMax,
                                qPrdEvaluateConfigPointDO.scoreMin,
                                qPrdEvaluateConfigPointDO.defScore,
                                qPrdEvaluateConfigPointDO.standardDesc

                        )).from(qPrdEvaluateConfigDtlDO).join(qPrdEvaluateConfigPointDO)
                        .on(qPrdEvaluateConfigDtlDO.pointId.eq(qPrdEvaluateConfigPointDO.id));

    }


    private Predicate bulidPredicate(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdEvaluateConfigDtlQuery.getConfigId(), qPrdEvaluateConfigDtlDO.configId, prdEvaluateConfigDtlQuery.getConfigId())
                .andEq(null != prdEvaluateConfigDtlQuery.getPointId(), qPrdEvaluateConfigDtlDO.pointId, prdEvaluateConfigDtlQuery.getPointId())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 配置id
        if (null != prdEvaluateConfigDtlQuery.getConfigId()) {
            predicates.add(qPrdEvaluateConfigDtlDO.configId.eq(prdEvaluateConfigDtlQuery.getConfigId()));
        }
        // 评价点id
        if (null != prdEvaluateConfigDtlQuery.getPointId()) {
            predicates.add(qPrdEvaluateConfigDtlDO.pointId.eq(prdEvaluateConfigDtlQuery.getPointId()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdEvaluateConfigDtlQuery prdEvaluateConfigDtlQuery) {

        long res = select(PrdEvaluateConfigDtlVO.class)
                .where(bulidPredicate(prdEvaluateConfigDtlQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdEvaluateConfigDtlPayload prdEvaluateConfigDtlPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEvaluateConfigDtlDO);

        // 配置id
        if (null != prdEvaluateConfigDtlPayload.getConfigId()) {
            update.set(qPrdEvaluateConfigDtlDO.configId, prdEvaluateConfigDtlPayload.getConfigId());
        }
        // 评价点id
        if (null != prdEvaluateConfigDtlPayload.getPointId()) {
            update.set(qPrdEvaluateConfigDtlDO.pointId, prdEvaluateConfigDtlPayload.getPointId());
        }
        long res = update.where(qPrdEvaluateConfigDtlDO.id.eq(prdEvaluateConfigDtlPayload.getId()))
                .execute();
        return res;

    }

    public Long delByConfigId(Long id) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdEvaluateConfigDtlDO);
        long res = update.set(qPrdEvaluateConfigDtlDO.deleteFlag, 1)
                .where(qPrdEvaluateConfigDtlDO.configId.eq(id))
                .execute();
        return res;

    }

}

