package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResultQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletResponse;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;
import java.util.List;


 /**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果
 */

@RestController
@RequestMapping("/api/prdPerformanceExamResult")
@RequiredArgsConstructor
@Api(value = "绩效考核结果", tags = {"绩效考核结果"})
public class PrdPerformanceExamResultController{
    
    private final PrdPerformanceExamResultService prdPerformanceExamResultService;
    
    
    @GetMapping("get/{id}")
    @ApiOperation("详情-绩效考核结果")
    public TwOutputUtil<PrdPerformanceExamResultVO> get(@PathVariable Long id) {
    
        PrdPerformanceExamResultVO res = prdPerformanceExamResultService.get(id);
        return TwOutputUtil.ok(res);
        
    }

     @GetMapping("getBySelf/{id}")
     @ApiOperation("详情-绩效考核结果(自评用接口)")
     public TwOutputUtil<PrdPerformanceExamResultVO> getBySelf(@PathVariable Long id) {

         PrdPerformanceExamResultVO res = prdPerformanceExamResultService.getBySelf(id);
         return TwOutputUtil.ok(res);

     }
    
    
    @PostMapping("save")
    @ApiOperation("新增-绩效考核结果")
    public TwOutputUtil<Long> save(@RequestBody PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {
        
        PrdPerformanceExamResultVO res = prdPerformanceExamResultService.save(prdPerformanceExamResultPayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @PostMapping("update")
    @ApiOperation("修改-绩效考核结果")
    public TwOutputUtil<Long> update(@RequestBody PrdPerformanceExamResultPayload prdPerformanceExamResultPayload) {
        
        PrdPerformanceExamResultVO res = prdPerformanceExamResultService.update(prdPerformanceExamResultPayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @DeleteMapping("del")
    @ApiOperation("删除-绩效考核结果")
    public TwOutputUtil<Long> del(Long[] ids) {
    
        Long res = prdPerformanceExamResultService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);
        
    }
    
    
    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-绩效考核结果")
    public TwOutputUtil<PagingVO<PrdPerformanceExamResultVO>> page(PrdPerformanceExamResultQuery prdPerformanceExamResultQuery) {
        
        PagingVO<PrdPerformanceExamResultVO> res = prdPerformanceExamResultService.page(prdPerformanceExamResultQuery);
        return TwOutputUtil.ok(res);
        
    }
    
    
    
}

