package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDate;

@Entity
@Table(name = "person_edu_experience", indexes = {
        @Index(name = "person_index", columnList = "person_id"),
})
@org.hibernate.annotations.Table(appliesTo = "person_edu_experience", comment = "人员-教育经历表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PersonEduExperienceDO extends BaseModel {

    @Comment("自然人ID")
    @Column(name = "person_id", nullable = false)
    private Long personId;

    @Comment("开始时间")
    @Column(name = "date_from")
    private LocalDate dateFrom;

    @Comment("结束时间")
    @Column(name = "date_to")
    private LocalDate dateTo;

    @Comment("学校名称")
    @Column(name = "school_name")
    private String schoolName;

    @Comment("专业名称")
    @Column(name = "major_name")
    private String majorName;

    @Comment("学历")
    @Column(name = "qualification")
    private String qualification;

    @Comment("学制")
    @Column(name = "edusys_type")
    private String edusysType;

    @Comment("专业描述")
    @Column(name = "major_desc", length = 500)
    private String majorDesc;

    @Comment("来源类型")
    @Column(name = "source_type")
    private String sourceType;
}
