package com.elitesland.tw.tw5.server.prd.humanresources.resource.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEmployeCompositeAbilityPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeCompositeAbilityVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-复合能力
 */

@RestController
@RequestMapping("/api/prdEmployeCompositeAbility")
@RequiredArgsConstructor
@Api(value = "员工-复合能力", tags = {"员工-复合能力"})
public class PrdEmployeCompositeAbilityController {

    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-员工-复合能力")
    public TwOutputUtil<PrdEmployeCompositeAbilityVO> get(@PathVariable Long id) {

        PrdEmployeCompositeAbilityVO res = prdEmployeCompositeAbilityService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-员工-复合能力")
    public TwOutputUtil<Long> save(@RequestBody PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {

        PrdEmployeCompositeAbilityVO res = prdEmployeCompositeAbilityService.save(prdEmployeCompositeAbilityPayload);
        return TwOutputUtil.ok(res.getId());

    }

    @PostMapping("batchSave")
    @ApiOperation("批量新增-员工-复合能力")
    public TwOutputUtil<Boolean> batchSave(@RequestBody List<PrdEmployeCompositeAbilityPayload> prdEmployeCompositeAbilityPayload) {

        Boolean res = prdEmployeCompositeAbilityService.batchSave(prdEmployeCompositeAbilityPayload);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("update")
    @ApiOperation("修改-员工-复合能力")
    public TwOutputUtil<Long> update(@RequestBody PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {

        PrdEmployeCompositeAbilityVO res = prdEmployeCompositeAbilityService.update(prdEmployeCompositeAbilityPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @DeleteMapping("del")
    @ApiOperation("删除-员工-复合能力")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdEmployeCompositeAbilityService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-员工-复合能力")
    public TwOutputUtil<PagingVO<PrdEmployeCompositeAbilityVO>> page(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {

        PagingVO<PrdEmployeCompositeAbilityVO> res = prdEmployeCompositeAbilityService.page(prdEmployeCompositeAbilityQuery);
        return TwOutputUtil.ok(res);

    }

    @PostMapping("updateMain")
    @ApiOperation("修改-员工-复合能力")
    public TwOutputUtil<Long> updateAbility(@RequestBody PrdEmployeCompositeAbilityPayload prdEmployeCompositeAbilityPayload) {

        Long res = prdEmployeCompositeAbilityService.updateAbility(prdEmployeCompositeAbilityPayload);
        return TwOutputUtil.ok(res);

    }


    @GetMapping("getList")
    @ApiOperation("获取员工对应复合能力列表")
    public TwOutputUtil<List<PrdEmployeCompositeAbilityVO>> getList(PrdEmployeCompositeAbilityQuery prdEmployeCompositeAbilityQuery) {

        List<PrdEmployeCompositeAbilityVO> res = prdEmployeCompositeAbilityService.getList(prdEmployeCompositeAbilityQuery);
        return TwOutputUtil.ok(res);

    }

}

