package com.elitesland.tw.tw5.server.prd.humanresources.resource.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResPortrayalEvalConfigPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResSearchQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResEvaluateService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResSearchService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResPortrayalVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResSearchVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/res/search")
@RequiredArgsConstructor
@Api(value = "资源查找", tags = {"资源查找"})
public class ResSearchController {

    private final ResSearchService resSearchService;

    private final ResEvaluateService resEvaluateService;

    /**
     * 资源查找分页查询
     *
     * @param query
     * @return result
     */
    @ApiOperation("资源查找分页")
    @GetMapping("/page")
    @UdcNameClass
    public TwOutputUtil<PagingVO<ResSearchVO>> page(ResSearchQuery query) {
        return TwOutputUtil.ok(resSearchService.queryPaging(query));
    }

    /**
     * 更新默认配置
     *
     * @param evalPointIds
     * @return result
     */
    @ApiOperation("更新默认配置")
    @PostMapping("/updateDefaultConfig")
    public TwOutputUtil updateResPortrayalEvalDefaultConfig(@RequestBody Long[] evalPointIds) {
        resEvaluateService.updateResPortrayalEvalDefaultConfig(evalPointIds);
        return TwOutputUtil.ok();
    }

    /**
     * 更新资源配置
     *
     * @param payload
     * @return result
     */
    @ApiOperation("更新资源配置")
    @PostMapping("/updateResConfig")
    public TwOutputUtil updateResPortrayalEvalConfig(@RequestBody ResPortrayalEvalConfigPayload payload) {
        resEvaluateService.updateResPortrayalEvalConfig(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 查询默认配置
     *
     * @param
     * @return result
     */
    @ApiOperation("查询默认配置")
    @GetMapping("/getDefaultConfig")
    public TwOutputUtil getResPortrayalEvalDefaultConfig() {
        return TwOutputUtil.ok(resEvaluateService.getResPortrayalEvalDefaultConfig());
    }

    /**
     * 查询资源配置
     *
     * @param userId
     * @return result
     */
    @ApiOperation("查询资源配置")
    @GetMapping("/getResConfig/{userId}")
    public TwOutputUtil getResPortrayalEvalDefaultConfig(@PathVariable Long userId) {
        return TwOutputUtil.ok(resEvaluateService.getResPortrayalEvalPoints(userId));
    }

    /**
     * 查看资源画像
     *
     * @param userId
     * @return result
     */
    @ApiOperation("查看资源画像")
    @GetMapping("/getPortrayal/{userId}")
    @UdcNameClass
    public TwOutputUtil<ResPortrayalVO> getPortrayal(@PathVariable Long userId) {
        return TwOutputUtil.ok(resSearchService.getPortrayal(userId));
    }
}
