package com.elitesland.tw.tw5.server.prd.humanresources.resource.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-复合能力
 */

@Entity
@Table(name = "prd_employe_composite_ability")
@org.hibernate.annotations.Table(appliesTo = "prd_employe_composite_ability", comment = "员工-复合能力")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdEmployeCompositeAbilityDO extends BaseModel {


    /**
     * 编号
     */
    @Column(name = "doc_no", columnDefinition = "varchar(255) comment '编号'")
    private String docNo;

    /**
     * 能力名称
     */
    @Column(name = "ability_name", columnDefinition = "varchar(255) comment '能力名称'")
    private String abilityName;

    /**
     * 能力id
     */
    @Column(name = "ability_id", columnDefinition = "bigint(20) comment '能力id'")
    private Long abilityId;

    /**
     * 能力描述
     */
    @Column(name = "ability_desc", columnDefinition = "varchar(255) comment '能力描述'")
    private String abilityDesc;

    /**
     * 主能力
     */
    @Column(name = "main_flag", columnDefinition = "tinyint(1) comment '主能力'")
    private Boolean mainFlag;

    /**
     * 辅能力
     */
    @Column(name = "aux_flag", columnDefinition = "tinyint(1) comment '辅能力'")
    private Boolean auxFlag;

    /**
     * 当量系数
     */
    @Column(name = "dl_ratio", columnDefinition = "decimal(20,4) comment '当量系数'")
    private BigDecimal dlRatio;

    /**
     * 获取时间
     */
    @Column(name = "obtain_time", columnDefinition = "date comment '获取时间'")
    private LocalDate obtainTime;

    /**
     * 上次认证时间
     */
    @Column(name = "last_cert_time", columnDefinition = "date comment '上次认证时间'")
    private LocalDate lastCertTime;

    /**
     * 过期时间
     */
    @Column(name = "expirate_time", columnDefinition = "date comment '过期时间'")
    private LocalDate expirateTime;

//    /**
//     * 员工id
//     */
//    @Column(name = "emp_id", columnDefinition = "bigint(20) comment '员工id'")
//    private Long empId;

    /**
     * 员工名称
     */
    @Column(name = "emp_name", columnDefinition = "varchar(255) comment '员工名称'")
    private String empName;

    /**
     * 员工编号
     */
    @Column(name = "emp_doc_no", columnDefinition = "varchar(255) comment '员工编号'")
    private String empDocNo;

    /**
     * 来源id
     */
    @Column(name = "form_id", columnDefinition = "bigint(20) comment '来源id'")
    private Long formId;

    /**
     * 状态
     */
    @Column(name = "state", columnDefinition = "int(11) comment '状态'")
    private Integer state;

    /**
     * 用户id
     */
    @Column(name = "user_id", columnDefinition = "bigint(20) comment '用户id'")
    private Long userId;

    /**
     * 级别定义id
     */
    @Column(name = "ability_level_id", columnDefinition = "bigint(20) comment '级别定义id'")
    private Long abilityLevelId;

}

