package com.elitesland.tw.tw5.server.prd.humanresources.resource.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;

@Entity
@Table(name = "res_withdrawal_apply_detail")
@org.hibernate.annotations.Table(appliesTo = "res_withdrawal_apply_detail", comment = "资源提现申请明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class ResWithdrawApplyDetailDO extends BaseModel {

    @Comment("提现申请单id")
    @Column()
    private Long applyId;

    @Comment("可提现当量")
    @Column(precision = 12, scale = 4)
    private BigDecimal avalQty;

    @Comment("结算单ID")
    @Column()
    private Long settleId;

    @Comment("结算单号")
    @Column()
    private String settleNo;

    @Comment("工作日期")
    @Column()
    private LocalDate workDate;

    @Comment("结算日期")
    @Column()
    private LocalDate settleDate;

    @Comment("可提现金额")
    @Column()
    private BigDecimal avalAmt;

    @Comment("调整提现金额")
    @Column()
    private BigDecimal adjWithdrawAmt;

    @Comment("当量收入")
    @Column(precision = 12, scale = 4)
    private BigDecimal approveSettleEqva;

    @Comment("现金收入")
    @Column()
    private BigDecimal approveIncomeAmt;

    @Comment("相关项目ID")
    @Column()
    private Long projId;

    @Comment("相关项目")
    @Column()
    private String projName;

    @Comment("相关任务ID")
    @Column()
    private Long taskId;

    @Comment("相关任务")
    @Column()
    private String taskName;


}
